/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseChunk;
import forestry.greenhouse.multiblock.blocks.world.NextTickEntry;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

class ChunkManager {
    public final Map<Long, GreenhouseChunk> id2ChunkMap = new Long2ObjectOpenHashMap(8192);
    public final List<Long> dirtyChunks = new ArrayList<Long>();
    private final Set<NextTickEntry> pendingTickEntries = Sets.newHashSet();
    private final TreeSet<NextTickEntry> pendingTickEntriesSorted = new TreeSet();
    private final List<NextTickEntry> pendingTickEntriesThisTick = Lists.newArrayList();
    private final World world;

    public ChunkManager(World world) {
        this.world = world;
    }

    public void markChunkDirty(long pos) {
        this.dirtyChunks.add(pos);
    }

    public List<Long> getDirtyChunks() {
        return this.dirtyChunks;
    }

    public GreenhouseChunk createChunk(long pos) {
        GreenhouseChunk chunk = new GreenhouseChunk();
        this.id2ChunkMap.put(pos, chunk);
        return chunk;
    }

    public GreenhouseChunk getOrCreateChunk(long pos) {
        GreenhouseChunk chunk = this.getChunk(pos);
        if (chunk == null) {
            chunk = this.createChunk(pos);
        }
        return chunk;
    }

    public GreenhouseChunk getChunk(long pos) {
        return this.id2ChunkMap.get(pos);
    }

    public void load(int x, int z) {
        long chunkPos = ChunkPos.func_77272_a((int)x, (int)z);
        this.updateChunk(x + 1, z, chunkPos);
        this.updateChunk(x - 1, z, chunkPos);
        this.updateChunk(x, z + 1, chunkPos);
        this.updateChunk(x, z - 1, chunkPos);
    }

    public void unload(int x, int z) {
        long pos = ChunkPos.func_77272_a((int)x, (int)z);
        GreenhouseChunk chunk = this.id2ChunkMap.remove(pos);
        if (chunk != null) {
            for (IGreenhouseProvider manager : chunk.getProviders()) {
                manager.onUnloadChunk(pos);
            }
        }
    }

    private void updateChunk(int x, int z, long updatedChunk) {
        GreenhouseChunk chunk = this.getChunk(ChunkPos.func_77272_a((int)x, (int)z));
        if (chunk != null) {
            for (IGreenhouseProvider manager : chunk.getProviders()) {
                if (!manager.hasUnloadedChunks()) continue;
                manager.onLoadChunk(updatedChunk);
            }
        }
    }

    public void scheduleUpdate(BlockPos pos, IGreenhouseProvider provider, int delay) {
        NextTickEntry entry = new NextTickEntry(pos, provider);
        entry.setScheduledTime((long)delay + this.getWorldTotalTime());
        if (!this.pendingTickEntries.contains(entry)) {
            this.pendingTickEntries.add(entry);
            this.pendingTickEntriesSorted.add(entry);
        }
    }

    public void tickUpdates() {
        NextTickEntry entry;
        int entriesCount = this.pendingTickEntriesSorted.size();
        if (entriesCount != this.pendingTickEntries.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        for (int entryCount = 0; entryCount < entriesCount; ++entryCount) {
            entry = this.pendingTickEntriesSorted.first();
            if (entry.scheduledTime > this.getWorldTotalTime()) break;
            this.pendingTickEntriesSorted.remove(entry);
            this.pendingTickEntries.remove(entry);
            this.pendingTickEntriesThisTick.add(entry);
        }
        Iterator<NextTickEntry> iterator = this.pendingTickEntriesThisTick.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            iterator.remove();
            if (this.world.func_175667_e(entry.getPosition())) {
                entry.getProvider().scheduledUpdate();
                continue;
            }
            this.scheduleUpdate(entry.getPosition(), entry.getProvider(), 0);
        }
        this.pendingTickEntriesThisTick.clear();
    }

    private long getWorldTotalTime() {
        return this.world.func_72912_H().func_82573_f();
    }
}

