/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IHiveTile;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.genetics.IAllele;
import forestry.apiculture.WorldgenBeekeepingLogic;
import forestry.apiculture.blocks.BlockBeeHives;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.apiculture.tiles.HiveBeeHousingInventory;
import forestry.core.config.Config;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.DamageSourceForestry;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.TickHelper;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileHive
extends TileEntity
implements ITickable,
IHiveTile,
IActivatable,
IBeeHousing {
    private static final DamageSource damageSourceBeeHive = new DamageSourceForestry("bee.hive");
    private final InventoryAdapter contained = new InventoryAdapter(2, "Contained");
    private final HiveBeeHousingInventory inventory;
    private final WorldgenBeekeepingLogic beeLogic;
    private final IErrorLogic errorLogic;
    private final Predicate<EntityLivingBase> beeTargetPredicate;
    private final TickHelper tickHelper = new TickHelper();
    @Nullable
    private IBee containedBee = null;
    private boolean active = false;
    private boolean angry = false;
    private int calmTime;
    private boolean updatedLight;

    public TileHive() {
        this.inventory = new HiveBeeHousingInventory(this);
        this.beeLogic = new WorldgenBeekeepingLogic(this);
        this.errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
        this.beeTargetPredicate = new BeeTargetPredicate(this);
    }

    public void func_73660_a() {
        if (Config.generateBeehivesDebug) {
            return;
        }
        this.tickHelper.onTick();
        if (this.field_145850_b.field_72995_K) {
            if (!this.updatedLight && this.tickHelper.updateOnInterval(100)) {
                this.updatedLight = this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            }
            if (this.active && this.tickHelper.updateOnInterval(4) && this.beeLogic.canDoBeeFX()) {
                this.beeLogic.doBeeFX();
            }
        } else {
            boolean canWork = this.beeLogic.canWork();
            if (this.tickHelper.updateOnInterval(this.angry ? 10 : 200)) {
                if (this.calmTime == 0) {
                    if (canWork) {
                        AxisAlignedBB boundingBox;
                        List entities;
                        if (this.field_145850_b.func_72912_H().func_176130_y() != EnumDifficulty.PEACEFUL && !(entities = this.field_145850_b.func_175647_a(EntityLivingBase.class, boundingBox = AlleleEffect.getBounding(this.getContainedBee().getGenome(), this), this.beeTargetPredicate)).isEmpty()) {
                            Collections.shuffle(entities);
                            EntityLivingBase entity = (EntityLivingBase)entities.get(0);
                            TileHive.attack(entity, 2);
                        }
                        this.beeLogic.doWork();
                    }
                } else {
                    --this.calmTime;
                }
            }
            this.setActive(this.calmTime == 0);
        }
    }

    public IBee getContainedBee() {
        if (this.containedBee == null) {
            IBee bee;
            IBeeGenome beeGenome = null;
            ItemStack containedBee = this.contained.func_70301_a(0);
            if (!containedBee.func_190926_b() && (bee = BeeManager.beeRoot.getMember(containedBee)) != null) {
                beeGenome = bee.getGenome();
            }
            if (beeGenome == null) {
                beeGenome = this.getGenomeFromBlock();
            }
            if (beeGenome == null) {
                beeGenome = BeeDefinition.FOREST.getGenome();
            }
            this.containedBee = BeeManager.beeRoot.getBee(beeGenome);
        }
        return this.containedBee;
    }

    @Nullable
    private IBeeGenome getGenomeFromBlock() {
        IHiveRegistry.HiveType hiveType;
        String speciesUid;
        IAllele[] template;
        IBlockState blockState;
        Block block;
        if (this.field_145850_b.func_175667_e(this.field_174879_c) && (block = (blockState = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c()) instanceof BlockBeeHives && (template = BeeManager.beeRoot.getTemplate(speciesUid = (hiveType = BlockBeeHives.getHiveType(blockState)).getSpeciesUid())) != null) {
            return BeeManager.beeRoot.templateAsGenome(template);
        }
        return null;
    }

    public void setContained(List<ItemStack> bees) {
        for (ItemStack itemstack : bees) {
            InventoryUtil.addStack((IInventory)this.contained, itemstack, true);
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.contained.readFromNBT(nbttagcompound);
        this.beeLogic.readFromNBT(nbttagcompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.contained.writeToNBT(nbttagcompound);
        this.beeLogic.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void calmBees() {
        this.calmTime = 5;
        this.angry = false;
        this.setActive(false);
    }

    @Override
    public boolean isAngry() {
        return this.angry;
    }

    @Override
    public void onAttack(World world, BlockPos pos, EntityPlayer player) {
        if (this.calmTime == 0) {
            this.angry = true;
        }
    }

    @Override
    public void onBroken(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        if (this.calmTime == 0) {
            TileHive.attack((EntityLivingBase)player, 10);
        }
        if (canHarvest) {
            for (ItemStack beeStack : InventoryUtil.getStacks((IInventory)this.contained)) {
                if (beeStack == null) continue;
                ItemStackUtil.dropItemStackAsEntity(beeStack, world, pos);
            }
        }
    }

    private static void attack(EntityLivingBase entity, int maxDamage) {
        double attackAmount = entity.field_70170_p.field_73012_v.nextDouble() / 2.0 + 0.5;
        int damage = (int)(attackAmount * (double)maxDamage);
        if (damage > 0) {
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, TileHive.damageSourceBeeHive.field_76373_n, true);
            if (entity.field_70170_p.field_73012_v.nextInt(4) >= count) {
                entity.func_70097_a(damageSourceBeeHive, (float)damage);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.field_145850_b.field_72995_K) {
            NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.field_174879_c, this.field_145850_b);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74757_a("active", this.calmTime == 0);
        this.beeLogic.writeToNBT(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.setActive(tag.func_74767_n("active"));
        this.beeLogic.readFromNBT(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.emptyList();
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public EnumHumidity getHumidity() {
        float humidity = ClimateUtil.getHumidity(this.func_145831_w(), this.func_174877_v());
        return EnumHumidity.getFromValue(humidity);
    }

    @Override
    public int getBlockLightValue() {
        return this.func_145831_w().func_72935_r() ? 15 : 0;
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return true;
    }

    @Override
    public boolean isRaining() {
        return this.field_145850_b.func_175727_C(this.func_174877_v().func_177984_a());
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }

    @Override
    public Biome getBiome() {
        return this.func_145831_w().func_180494_b(this.func_174877_v());
    }

    @Override
    @Nullable
    public GameProfile getOwner() {
        return null;
    }

    @Override
    public Vec3d getBeeFXCoordinates() {
        BlockPos pos = this.func_174877_v();
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5);
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    private static class BeeTargetPredicate
    implements Predicate<EntityLivingBase> {
        private final IHiveTile hive;

        public BeeTargetPredicate(IHiveTile hive) {
            this.hive = hive;
        }

        public boolean apply(@Nullable EntityLivingBase input) {
            if (input != null && input.func_70089_S() && !input.func_82150_aj()) {
                if (input instanceof EntityPlayer) {
                    return EntitySelectors.field_188444_d.apply((Object)input);
                }
                if (this.hive.isAngry()) {
                    return true;
                }
                if (input instanceof IMob) {
                    return !(input instanceof EntityEnderman) && !(input instanceof EntityPigZombie);
                }
            }
            return false;
        }
    }
}

