/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.core.GuiElementAlignment;
import forestry.core.gui.elements.GuiElement;
import forestry.core.render.ColourProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class GuiElementText
extends GuiElement {
    public static final FontRenderer FONT_RENDERER = Minecraft.func_71410_x().field_71466_p;
    protected final String text;
    protected final int color;
    protected final GuiElementAlignment align;

    public GuiElementText(int xPos, int yPos, int height, String text) {
        this(xPos, yPos, FONT_RENDERER.func_78256_a(text), height, text, GuiElementAlignment.LEFT);
    }

    public GuiElementText(int xPos, int yPos, int height, String text, int color) {
        this(xPos, yPos, FONT_RENDERER.func_78256_a(text), height, text, GuiElementAlignment.LEFT, color);
    }

    public GuiElementText(int xPos, int yPos, int width, int height, String text) {
        this(xPos, yPos, width, height, text, GuiElementAlignment.LEFT);
    }

    public GuiElementText(int xPos, int yPos, int width, int height, String text, GuiElementAlignment align) {
        this(xPos, yPos, width, height, text, align, ColourProperties.INSTANCE.get("gui.screen"));
    }

    public GuiElementText(String text, GuiElementAlignment align, int color) {
        this(0, 0, FONT_RENDERER.func_78256_a(text), 12, text, align, color);
    }

    public GuiElementText(int xPos, int yPos, int width, int height, String text, int color) {
        this(xPos, yPos, width, height, text, GuiElementAlignment.LEFT, color);
    }

    public GuiElementText(int xPos, int yPos, int width, int height, String text, GuiElementAlignment align, int color) {
        super(xPos, yPos, width, height);
        this.text = text;
        this.align = align;
        this.color = color;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void draw(int startX, int startY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FONT_RENDERER.func_78276_b(this.text, this.getX() + this.getOffset() + startX, this.getY() + startY, this.color);
    }

    public int getOffset() {
        switch (this.align) {
            case RIGHT: {
                return this.width - FONT_RENDERER.func_78256_a(this.text);
            }
            case CENTER: {
                return (this.width - FONT_RENDERER.func_78256_a(this.text)) / 2;
            }
        }
        return 0;
    }
}

