/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui.widgets;

import forestry.core.gui.tooltips.ToolTip;
import forestry.greenhouse.api.climate.IClimateModifier;
import forestry.greenhouse.gui.widgets.WidgetClimatePanel;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetClimateModifier {
    public static final int WIDTH = 18;
    public static final int HEIGHT = 18;
    private final int xPos;
    private final int yPos;
    private final WidgetClimatePanel parent;
    private final IClimateModifier modifier;
    private final ToolTip toolTip = new ToolTip(250){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void refresh() {
            WidgetClimateModifier.this.toolTip.clear();
            WidgetClimateModifier.this.toolTip.add(WidgetClimateModifier.this.modifier.getName());
            ArrayList<String> lines = new ArrayList<String>();
            ((WidgetClimateModifier)WidgetClimateModifier.this).parent.gui.container.addModifierInformation(WidgetClimateModifier.this.modifier, WidgetClimateModifier.this.parent.getType(), lines);
            for (String line : lines) {
                WidgetClimateModifier.this.toolTip.add(line, TextFormatting.GRAY);
            }
        }
    };

    public WidgetClimateModifier(WidgetClimatePanel parent, int xPos, int yPos, IClimateModifier modifier) {
        this.parent = parent;
        this.xPos = xPos;
        this.yPos = yPos;
        this.modifier = modifier;
    }

    public void draw(int startX, int startY) {
        if (!this.isVisible()) {
            return;
        }
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(this.modifier.getTextureMap());
        TextureAtlasSprite icon = this.modifier.getIcon();
        if (icon == null) {
            RenderHelper.func_74520_c();
            ItemStack stack = this.modifier.getIconItemStack();
            FontRenderer font = null;
            if (!stack.func_190926_b()) {
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (font == null) {
                font = this.parent.gui.getFontRenderer();
            }
            RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
            itemRender.func_184391_a(null, stack, this.xPos + startX, this.yPos + startY);
            itemRender.func_180453_a(font, stack, this.xPos + startX, this.yPos + startY, null);
            RenderHelper.func_74518_a();
        } else {
            this.parent.gui.func_175175_a(startX + this.xPos, startY + this.yPos, icon, 16, 16);
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.xPos && mouseX < this.xPos + 18 && mouseY >= this.yPos && mouseY < this.yPos + 18;
    }

    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return null;
        }
        if (!this.isMouseOver(mouseX, mouseY)) {
            return null;
        }
        return this.toolTip;
    }

    private boolean isVisible() {
        return true;
    }
}

