/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.base.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmRegistry;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.farming.logic.FarmableDoubleCrop;
import forestry.plugins.CompatPlugin;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry_compat", moduleID="immersiveengineering", name="ImmersiveEngineering", author="marcin212", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.immersiveengineering.description")
public class PluginImmersiveEngineering
extends CompatPlugin {
    public PluginImmersiveEngineering() {
        super("ImmersiveEngineering", "immersiveengineering");
    }

    @Override
    public void postInit() {
        Fluid ethanol;
        IFarmRegistry farmRegistry = ForestryAPI.farmRegistry;
        ItemStack hempSeed = this.getItemStack("seed");
        Block hempCrop = this.getBlock("hemp");
        if (hempCrop != null) {
            int seedAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
            Stream propertyStream = hempCrop.func_176194_O().func_177623_d().stream();
            IProperty age = propertyStream.filter(p -> p.func_177701_a().equals("type")).findAny().orElseGet(null);
            if (hempSeed != null && hempCrop != Blocks.field_150350_a && age != null) {
                Optional bottom0 = age.func_185929_b("bottom0");
                Optional bottom4 = age.func_185929_b("bottom4");
                Optional top0 = age.func_185929_b("top0");
                if (bottom0.isPresent() && top0.isPresent()) {
                    IBlockState defaultState = hempCrop.func_176223_P();
                    IBlockState planted = defaultState.func_177226_a(age, (Comparable)bottom0.get());
                    IBlockState mature = defaultState.func_177226_a(age, (Comparable)bottom4.get());
                    IBlockState topMature = defaultState.func_177226_a(age, (Comparable)top0.get());
                    farmRegistry.registerFarmables("farmWheat", new FarmableDoubleCrop(hempSeed, planted, mature, topMature, false));
                    farmRegistry.registerFarmables("farmOrchard", new FarmableDoubleCrop(hempSeed, planted, mature, topMature, true));
                    RecipeManagers.squeezerManager.addRecipe(10, hempSeed, Fluids.SEED_OIL.getFluid(seedAmount));
                }
            }
        }
        if ((ethanol = FluidRegistry.getFluid((String)"ethanol")) != null) {
            GeneratorFuel ethanolFuel = new GeneratorFuel(new FluidStack(ethanol, 1), (int)(32.0f * ForestryAPI.activeMode.getFloatSetting("fuel.ethanol.generator")), 4);
            FuelManager.generatorFuel.put(ethanol, ethanolFuel);
        }
    }
}

