/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class Chromosome
implements IChromosome {
    public static final String UID0_TAG = "UID0";
    public static final String UID1_TAG = "UID1";
    private final IAllele primary;
    private final IAllele secondary;

    public static Chromosome create(@Nullable String primarySpeciesUid, @Nullable String secondarySpeciesUid, IChromosomeType chromosomeType, NBTTagCompound nbt) {
        IAllele primary = AlleleManager.alleleRegistry.getAllele(nbt.func_74779_i(UID0_TAG));
        IAllele secondary = AlleleManager.alleleRegistry.getAllele(nbt.func_74779_i(UID1_TAG));
        primary = Chromosome.validateAllele(primarySpeciesUid, chromosomeType, primary);
        secondary = Chromosome.validateAllele(secondarySpeciesUid, chromosomeType, secondary);
        return new Chromosome(primary, secondary);
    }

    private static IAllele validateAllele(@Nullable String speciesUid, IChromosomeType chromosomeType, @Nullable IAllele allele) {
        if (!chromosomeType.getAlleleClass().isInstance(allele)) {
            ISpeciesRoot speciesRoot = chromosomeType.getSpeciesRoot();
            IAllele[] template = null;
            if (speciesUid != null) {
                template = speciesRoot.getTemplate(speciesUid);
            }
            if (template == null) {
                template = speciesRoot.getDefaultTemplate();
            }
            return template[chromosomeType.ordinal()];
        }
        return allele;
    }

    public Chromosome(IAllele allele) {
        this.primary = this.secondary = allele;
    }

    public Chromosome(IAllele primary, IAllele secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a(UID0_TAG, this.primary.getUID());
        nbttagcompound.func_74778_a(UID1_TAG, this.secondary.getUID());
        return nbttagcompound;
    }

    @Override
    public IAllele getPrimaryAllele() {
        return this.primary;
    }

    @Override
    public IAllele getSecondaryAllele() {
        return this.secondary;
    }

    @Override
    public IAllele getActiveAllele() {
        if (this.primary.isDominant()) {
            return this.primary;
        }
        if (this.secondary.isDominant()) {
            return this.secondary;
        }
        return this.primary;
    }

    @Override
    public IAllele getInactiveAllele() {
        if (!this.secondary.isDominant()) {
            return this.secondary;
        }
        if (!this.primary.isDominant()) {
            return this.primary;
        }
        return this.secondary;
    }

    public static IChromosome inheritChromosome(Random rand, IChromosome parent1, IChromosome parent2) {
        IAllele choice1 = rand.nextBoolean() ? parent1.getPrimaryAllele() : parent1.getSecondaryAllele();
        IAllele choice2 = rand.nextBoolean() ? parent2.getPrimaryAllele() : parent2.getSecondaryAllele();
        if (rand.nextBoolean()) {
            return new Chromosome(choice1, choice2);
        }
        return new Chromosome(choice2, choice1);
    }

    public String toString() {
        return "{" + this.primary + ", " + this.secondary + "}";
    }
}

