/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.Genome;
import forestry.core.genetics.alleles.AlleleArea;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.genetics.alleles.AlleleTolerance;
import java.util.concurrent.TimeUnit;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3i;

public class BeeGenome
extends Genome
implements IBeeGenome {
    private static final LoadingCache<NBTTagCompound, BeeGenome> beeGenomeCache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<NBTTagCompound, BeeGenome>(){

        public BeeGenome load(NBTTagCompound tagCompound) {
            return new BeeGenome(tagCompound);
        }
    });

    public static BeeGenome fromNBT(NBTTagCompound nbtTagCompound) {
        return (BeeGenome)beeGenomeCache.getUnchecked((Object)nbtTagCompound);
    }

    private BeeGenome(NBTTagCompound nbttagcompound) {
        super(nbttagcompound);
    }

    public BeeGenome(IChromosome[] chromosomes) {
        super(chromosomes);
    }

    public static IAlleleBeeSpecies getSpecies(ItemStack itemStack) {
        Preconditions.checkArgument((boolean)BeeManager.beeRoot.isMember(itemStack), (Object)"itemStack must be a bee");
        IAlleleSpecies species = BeeGenome.getSpeciesDirectly(itemStack);
        if (species instanceof IAlleleBeeSpecies) {
            return (IAlleleBeeSpecies)species;
        }
        return (IAlleleBeeSpecies)BeeGenome.getActiveAllele(itemStack, EnumBeeChromosome.SPECIES, BeeManager.beeRoot);
    }

    @Override
    public IAlleleBeeSpecies getPrimary() {
        return (IAlleleBeeSpecies)this.getActiveAllele(EnumBeeChromosome.SPECIES);
    }

    @Override
    public IAlleleBeeSpecies getSecondary() {
        return (IAlleleBeeSpecies)this.getInactiveAllele(EnumBeeChromosome.SPECIES);
    }

    @Override
    public float getSpeed() {
        return ((IAlleleFloat)this.getActiveAllele(EnumBeeChromosome.SPEED)).getValue();
    }

    @Override
    public int getLifespan() {
        return ((IAlleleInteger)this.getActiveAllele(EnumBeeChromosome.LIFESPAN)).getValue();
    }

    @Override
    public int getFertility() {
        return ((IAlleleInteger)this.getActiveAllele(EnumBeeChromosome.FERTILITY)).getValue();
    }

    @Override
    public EnumTolerance getToleranceTemp() {
        return ((AlleleTolerance)this.getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE)).getValue();
    }

    @Override
    public boolean getNeverSleeps() {
        return ((AlleleBoolean)this.getActiveAllele(EnumBeeChromosome.NEVER_SLEEPS)).getValue();
    }

    @Override
    public EnumTolerance getToleranceHumid() {
        return ((AlleleTolerance)this.getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE)).getValue();
    }

    @Override
    public boolean getToleratesRain() {
        return ((AlleleBoolean)this.getActiveAllele(EnumBeeChromosome.TOLERATES_RAIN)).getValue();
    }

    @Override
    public boolean getCaveDwelling() {
        return ((AlleleBoolean)this.getActiveAllele(EnumBeeChromosome.CAVE_DWELLING)).getValue();
    }

    @Override
    public IFlowerProvider getFlowerProvider() {
        return ((IAlleleFlowers)this.getActiveAllele(EnumBeeChromosome.FLOWER_PROVIDER)).getProvider();
    }

    @Override
    public int getFlowering() {
        return ((IAlleleInteger)this.getActiveAllele(EnumBeeChromosome.FLOWERING)).getValue();
    }

    @Override
    public Vec3i getTerritory() {
        return ((AlleleArea)this.getActiveAllele(EnumBeeChromosome.TERRITORY)).getArea();
    }

    @Override
    public IAlleleBeeEffect getEffect() {
        return (IAlleleBeeEffect)this.getActiveAllele(EnumBeeChromosome.EFFECT);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return BeeManager.beeRoot;
    }
}

