/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.Crop;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CropDestroyDouble
extends Crop {
    protected final IBlockState blockState;
    protected final IBlockState blockStateUp;
    @Nullable
    protected final IBlockState replantState;

    public CropDestroyDouble(World world, IBlockState blockState, IBlockState blockStateUp, BlockPos position, @Nullable IBlockState replantState) {
        super(world, position);
        this.blockState = blockState;
        this.blockStateUp = blockStateUp;
        this.replantState = replantState;
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        return world.func_180495_p(pos) == this.blockState;
    }

    @Override
    protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
        Block block = this.blockState.func_177230_c();
        Block blockUp = this.blockStateUp.func_177230_c();
        NonNullList harvested = NonNullList.func_191196_a();
        harvested.addAll((Collection)block.getDrops((IBlockAccess)world, pos, this.blockState, 0));
        harvested.addAll((Collection)blockUp.getDrops((IBlockAccess)world, pos.func_177984_a(), this.blockStateUp, 0));
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, this.blockState);
        NetworkUtil.sendNetworkPacket(packet, pos, world);
        world.func_175698_g(pos.func_177984_a());
        if (this.replantState != null) {
            world.func_180501_a(pos, this.replantState, 2);
        } else {
            world.func_175698_g(pos);
        }
        return harvested;
    }

    public String toString() {
        return String.format("CropDestroyDouble [ position: [ %s ]; block: %s ]", this.position.toString(), this.blockState);
    }
}

