/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate.modifiers;

import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.climate.IClimateModifier;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TimeModifier
implements IClimateModifier {
    private static final float TEMPERATURE_CHANGE = 0.05f;

    private static float calculateLightRatio(World world) {
        int lightValue = EnumSkyBlock.SKY.field_77198_c - world.func_175657_ab();
        float sunAngle = world.func_72929_e(1.0f);
        if (!world.func_72935_r()) {
            lightValue = EnumSkyBlock.SKY.field_77198_c - lightValue;
        }
        sunAngle = sunAngle < (float)Math.PI ? (sunAngle -= sunAngle * 0.2f) : (sunAngle += ((float)Math.PI * 2 - sunAngle) * 0.2f);
        lightValue = Math.round((float)lightValue * MathHelper.func_76134_b((float)sunAngle));
        lightValue = MathHelper.func_76125_a((int)lightValue, (int)-15, (int)15);
        return (float)lightValue / 15.0f;
    }

    @Override
    public IClimateState modifyTarget(IClimateContainer container, IClimateState newState, IClimateState oldState, NBTTagCompound data) {
        World world = container.getWorld();
        float lightRatio = TimeModifier.calculateLightRatio(world);
        float temperatureChange = lightRatio * 0.05f;
        data.func_74776_a("timeTemperatureChange", temperatureChange);
        return newState.addTemperature(temperatureChange);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(IClimateContainer container, NBTTagCompound nbtData, ClimateType type, List<String> lines) {
        lines.add(Translator.translateToLocalFormatted("for.gui.modifier.time", StringUtil.floatAsPercent(nbtData.func_74760_g("timeTemperatureChange"))));
    }

    @Override
    public boolean canModify(ClimateType type) {
        return type == ClimateType.TEMPERATURE;
    }

    @Override
    public String getName() {
        return Translator.translateToLocal("for.gui.modifier.time.title");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getIconItemStack() {
        return new ItemStack(Items.field_151113_aN);
    }
}

