/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules;

import com.google.common.collect.ImmutableSet;
import forestry.api.modules.IForestryModule;
import forestry.api.modules.IModuleHandler;
import forestry.core.utils.Log;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleManager;
import java.util.Collection;
import java.util.Set;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ModuleHandler
implements IModuleHandler {
    private final Set<IForestryModule> modules;
    private final ModuleManager manager;

    public ModuleHandler(Collection<IForestryModule> modules, ModuleManager manager) {
        this.modules = ImmutableSet.copyOf(modules);
        this.manager = manager;
    }

    @Override
    public void runSetup() {
        for (IForestryModule module : this.modules) {
            Log.debug("Setup API Start: {}", module);
            module.setupAPI();
            Log.debug("Setup API Complete: {}", module);
        }
        for (IForestryModule module : this.modules) {
            Log.debug("Disabled-Setup Start: {}", module);
            module.disabledSetupAPI();
            Log.debug("Disabled-Setup Complete: {}", module);
        }
        for (IForestryModule module : this.modules) {
            Log.debug("Register Items and Blocks Start: {}", module);
            module.registerItemsAndBlocks();
            Log.debug("Register Items and Blocks Complete: {}", module);
        }
    }

    @Override
    public void runPreInit() {
        for (IForestryModule module : this.modules) {
            Log.debug("Pre-Init Start: {}", module);
            if (module instanceof BlankForestryModule) {
                BlankForestryModule moduleInternal = (BlankForestryModule)module;
                ModuleManager.registerHandlers(moduleInternal, FMLCommonHandler.instance().getEffectiveSide());
            }
            module.preInit();
            if (this.manager.isModuleEnabled("forestry", "buildcraft.statements")) {
                module.registerTriggers();
            }
            Log.debug("Pre-Init Complete: {}", module);
        }
    }

    @Override
    public void runInit() {
        for (IForestryModule module : this.modules) {
            Log.debug("Init Start: {}", module);
            module.doInit();
            module.registerRecipes();
            Log.debug("Init Complete: {}", module);
        }
    }

    @Override
    public void runPostInit() {
        for (IForestryModule module : this.modules) {
            Log.debug("Post-Init Start: {}", module);
            module.postInit();
            Log.debug("Post-Init Complete: {}", module);
        }
    }

    public Set<IForestryModule> getModules() {
        return this.modules;
    }
}

