package forestry.core.models;

import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;

public class SimpleRetexturedModel extends BlankModel {

	public final IModel model;
	@Nullable
	public IBakedModel bakedModel;

	public SimpleRetexturedModel(IModel model) {
		this.model = model;
	}

	@Override
	public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
		return getModel().func_188616_a(state, side, rand);
	}

	@Override
	protected ItemOverrideList createOverrides() {
		return new RetexturedOverrideList(model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, DefaultTextureGetter.INSTANCE));
	}

	@Override
	public TextureAtlasSprite func_177554_e() {
		return getModel().func_177554_e();
	}

	private IBakedModel getModel() {
		if (bakedModel == null) {
			return bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176600_a, DefaultTextureGetter.INSTANCE);
		}
		return bakedModel;
	}

	private static class RetexturedOverrideList extends ItemOverrideList {
		public final IBakedModel bakedModel;

		public RetexturedOverrideList(IBakedModel bakedModel) {
			super(Collections.emptyList());

			this.bakedModel = bakedModel;
		}

		@Override
		public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
			return bakedModel;
		}

	}

}
