/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.core.utils.MigrationHelper;
import forestry.modules.ModuleManager;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class BlockRegistry {
    protected <T extends Block> void registerBlock(T block, @Nullable ItemBlock itemBlock, String name) {
        if (ModuleManager.getStage() != ModuleManager.Stage.REGISTER) {
            throw new RuntimeException("Tried to register Block outside of REGISTER");
        }
        if (!name.equals(name.toLowerCase(Locale.ENGLISH))) {
            Log.error("Name must be lowercase", new Object[0]);
        }
        block.func_149663_c("for." + name);
        block.setRegistryName(name);
        ForgeRegistries.BLOCKS.register(block);
        Proxies.common.registerBlock(block);
        MigrationHelper.addBlockName(name);
        if (itemBlock != null) {
            itemBlock.setRegistryName(name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
            Proxies.common.registerItem((Item)itemBlock);
            MigrationHelper.addItemName(name);
        }
    }

    protected <T extends Block> void registerBlock(T block, String name) {
        this.registerBlock(block, null, name);
    }

    protected static void registerOreDictWildcard(String oreDictName, Block block) {
        OreDictionary.registerOre((String)oreDictName, (ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
    }
}

