/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.core.ModuleCore;
import forestry.core.blocks.BlockResourceOre;
import forestry.core.blocks.EnumResourceType;
import forestry.core.config.Config;
import forestry.modules.ModuleManager;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGenerator
implements IWorldGenerator {
    @Nullable
    private WorldGenMinable apatiteGenerator;
    @Nullable
    private WorldGenMinable copperGenerator;
    @Nullable
    private WorldGenMinable tinGenerator;

    public WorldGenerator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world);
    }

    @SubscribeEvent
    public void populateChunk(PopulateChunkEvent.Post event) {
        ModuleManager.populateChunk(event.getGen(), event.getWorld(), event.getRand(), event.getChunkX(), event.getChunkZ(), event.isHasVillageGenerated());
    }

    @SubscribeEvent
    public void decorateBiome(DecorateBiomeEvent.Post event) {
        ModuleManager.decorateBiome(event.getWorld(), event.getRand(), event.getPos());
    }

    public void retroGen(Random random, int chunkX, int chunkZ, World world) {
        this.generateWorld(random, chunkX, chunkZ, world);
        ModuleManager.populateChunkRetroGen(world, random, chunkX, chunkZ);
        world.func_72964_e(chunkX, chunkZ).func_76630_e();
    }

    private void generateWorld(Random random, int chunkX, int chunkZ, World world) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int range;
        if (this.apatiteGenerator == null || this.copperGenerator == null || this.tinGenerator == null) {
            BlockResourceOre resourcesBlock = ModuleCore.getBlocks().resources;
            IBlockState apatiteBlockState = resourcesBlock.func_176203_a(EnumResourceType.APATITE.getMeta());
            IBlockState copperBlockState = resourcesBlock.func_176203_a(EnumResourceType.COPPER.getMeta());
            IBlockState tinBlockState = resourcesBlock.func_176203_a(EnumResourceType.TIN.getMeta());
            this.apatiteGenerator = new WorldGenMinable(apatiteBlockState, 36);
            this.copperGenerator = new WorldGenMinable(copperBlockState, 6);
            this.tinGenerator = new WorldGenMinable(tinBlockState, 6);
        }
        int x = chunkX << 4;
        int y = chunkZ << 4;
        if (Config.generateApatiteOre) {
            int lowest = Math.round((float)world.func_72940_L() * 0.22f);
            int range2 = Math.round((float)world.func_72940_L() * 0.72f);
            if (random.nextFloat() < 0.8f) {
                int randPosX2 = x + random.nextInt(16);
                int randPosY2 = random.nextInt(range2) + lowest;
                int randPosZ2 = y + random.nextInt(16);
                this.apatiteGenerator.func_180709_b(world, random, new BlockPos(randPosX2, randPosY2, randPosZ2));
            }
        }
        if (Config.generateCopperOre) {
            for (int i = 0; i < 20; ++i) {
                int lowest = Math.round((float)world.func_72940_L() / 8.0f);
                range = Math.round((float)world.func_72940_L() * 0.297f);
                randPosX = x + random.nextInt(16);
                randPosY = random.nextInt(range) + lowest;
                randPosZ = y + random.nextInt(16);
                this.copperGenerator.func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
            }
        }
        if (Config.generateTinOre) {
            for (int i = 0; i < 18; ++i) {
                int lowest = Math.round((float)world.func_72940_L() / 16.0f);
                range = Math.round((float)world.func_72940_L() * 0.297f);
                randPosX = x + random.nextInt(16);
                randPosY = random.nextInt(range) + lowest;
                randPosZ = y + random.nextInt(16);
                this.tinGenerator.func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
            }
        }
    }
}

