package forestry.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;

import net.minecraft.item.ItemStack;

public class DatabaseHelper {
	public static boolean ascending;

	public static final Comparator<DatabaseItem> SORT_BY_NAME = (DatabaseItem firstStack, DatabaseItem secondStack) -> {
		if(firstStack.itemStack.func_190926_b() && !secondStack.itemStack.func_190926_b()){
			return 1;
		}else if(!firstStack.itemStack.func_190926_b() && secondStack.itemStack.func_190926_b()){
			return -1;
		}
		if(ascending) {
			return getItemName(firstStack.itemStack).compareToIgnoreCase(getItemName(secondStack.itemStack));
		}
		return getItemName(secondStack.itemStack).compareToIgnoreCase(getItemName(firstStack.itemStack));
	};

	public static String getItemName(ItemStack itemStack){
		try {
			String name = itemStack.func_82833_r();
			if (name == null || name.isEmpty()) {
				name = itemStack.func_77973_b().func_77667_c(itemStack);
			}
			return name == null ? "Null" : name;
		}catch( final Exception errA ) {
			try {
				String name = itemStack.func_77977_a();
				return name == null ? "Null" : name;
			} catch( final Exception errB ) {
				return "Exception";
			}
		}
	}

	public static void update(String searchText, List<DatabaseItem> items, ArrayList<DatabaseItem> sorted){
		sorted.clear();

		sorted.ensureCapacity(items.size());

		Pattern pattern;
		try {
			pattern = Pattern.compile(searchText.toLowerCase(), Pattern.CASE_INSENSITIVE);
		} catch(Throwable ignore) {
			try {
				pattern = Pattern.compile(Pattern.quote(searchText.toLowerCase()), Pattern.CASE_INSENSITIVE);
			} catch(Throwable e) {
				return;
			}
		}

		List<Predicate<ItemStack>> filters = getFilters(pattern, searchText);
		//boolean hasAddedItem;
		for(DatabaseItem databaseItem : items) {
			ItemStack item = databaseItem.itemStack;
			final String name = DatabaseHelper.getItemName(item);
			for(Predicate<ItemStack> filter : filters){
				if(filter.test(item)){
					sorted.add(databaseItem);
					break;
				}
			}

			/*if(pattern.matcher(name.toLowerCase()).find() || item.isEmpty()) {
				sorted.add(databaseItem);
				continue;
			}

			List<String> lines = item.getTooltip(Minecraft.getMinecraft().player, ITooltipFlag.TooltipFlags.NORMAL);
			for(String tooltip : lines) {
				if(pattern.matcher(tooltip).find()) {
					sorted.add(databaseItem);
					break;
				}
			}*/
		}

		Collections.sort(sorted, SORT_BY_NAME);
	}

	//TODO: Add more filter options
	public static List<Predicate<ItemStack>> getFilters(Pattern pattern, String searchText){
		List<Predicate<ItemStack>> filters = new LinkedList<>();
		filters.add(new DatabaseFilterName(pattern));
		filters.add(new DatabaseFilterToolTip(pattern));
		return filters;
	}
}
