package forestry.core.render;

import java.util.LinkedHashMap;
import java.util.Map;

import com.google.common.collect.Maps;
import forestry.core.blocks.BlockBase;
import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IMachinePropertiesTesr;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class MachineStateMapper<T extends Enum<T> & IBlockType & IStringSerializable> extends ForestryStateMapper {

	private final T type;

	public MachineStateMapper(T type) {
		this.type = type;
	}

	@Override
	public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
		if (!(type.getMachineProperties() instanceof IMachinePropertiesTesr)) {
			for (EnumFacing facing : EnumFacing.values()) {
				if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
					continue;
				}
				IBlockState state = block.func_176223_P().func_177226_a(BlockBase.FACING, facing);
				LinkedHashMap<IProperty<?>, Comparable<?>> linkedhashmap = Maps.newLinkedHashMap(state.func_177228_b());
				ResourceLocation blockLocation = Block.field_149771_c.func_177774_c(block);
				String s = String.format("%s:%s", blockLocation.func_110624_b(), blockLocation.func_110623_a());
				mapStateModelLocations.put(state, new ModelResourceLocation(s, getPropertyString(linkedhashmap)));
			}
		}

		return this.mapStateModelLocations;
	}

}
