/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import forestry.api.multiblock.IGreenhouseComponent;
import forestry.core.multiblock.MultiblockUtil;
import forestry.greenhouse.PluginGreenhouse;
import forestry.greenhouse.api.greenhouse.IGreenhouseLimits;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.api.greenhouse.Position2D;
import forestry.greenhouse.items.ItemGreenhouseScreen;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GreenhouseEventHandler {
    protected long previousCheckTick = 0L;
    protected Set<BlockPos> greenhousePositions = new HashSet<BlockPos>();

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        try {
            double distance;
            float partialTicks = event.getPartialTicks();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            World world = player.field_70170_p;
            long tick = world.func_82737_E();
            if (tick > this.previousCheckTick + 50L) {
                this.greenhousePositions.clear();
                for (ItemStack itemStack : this.getClimateScreen(player.field_71071_by)) {
                    if (itemStack.func_190926_b()) continue;
                    BlockPos position = ItemGreenhouseScreen.getGreenhousePos(itemStack);
                    IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController((IBlockAccess)world, position, IGreenhouseComponent.class);
                    if (controller == null || !controller.isAssembled()) {
                        return;
                    }
                    position = controller.getCenterCoordinates();
                    distance = MathHelper.func_76133_a((double)player.func_174831_c(position));
                    if (distance > 64.0) {
                        return;
                    }
                    this.greenhousePositions.add(position);
                }
                this.previousCheckTick = tick;
            }
            for (BlockPos position : this.greenhousePositions) {
                IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController((IBlockAccess)world, position, IGreenhouseComponent.class);
                if (controller == null || !controller.isAssembled()) {
                    return;
                }
                IGreenhouseProvider provider = controller.getProvider();
                position = controller.getCenterCoordinates();
                distance = MathHelper.func_76133_a((double)player.func_174831_c(position));
                if (distance > 64.0) {
                    return;
                }
                double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179090_x();
                GlStateManager.func_187441_d((float)2.5f);
                IGreenhouseLimits limits = provider.getUsedLimits();
                if (limits != null) {
                    Position2D minEdge = limits.getMinimumCoordinates();
                    Position2D maxEdge = limits.getMaximumCoordinates();
                    AxisAlignedBB greenhouseBB = new AxisAlignedBB((double)minEdge.getX(), (double)limits.getDepth(), (double)minEdge.getZ(), (double)(maxEdge.getX() + 1), (double)(limits.getHeight() + 1), (double)(maxEdge.getZ() + 1));
                    RenderGlobal.func_189697_a((AxisAlignedBB)greenhouseBB, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                }
                BlockPos offset = provider.getCenterPos();
                AxisAlignedBB testBlockBB = Block.field_185505_j.func_186670_a(offset);
                RenderGlobal.func_189697_a((AxisAlignedBB)testBlockBB, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.previousCheckTick = 0L;
    }

    private NonNullList<ItemStack> getClimateScreen(InventoryPlayer inventoryPlayer) {
        NonNullList climateScreens = NonNullList.func_191196_a();
        NonNullList items = NonNullList.func_191196_a();
        items.addAll(inventoryPlayer.field_70462_a);
        items.addAll(inventoryPlayer.field_184439_c);
        for (ItemStack stack : items) {
            if (stack.func_190926_b() || stack.func_77973_b() != PluginGreenhouse.getItems().greenhouseScreen || !ItemGreenhouseScreen.isPreviewModeActive(stack) || !ItemGreenhouseScreen.isValid(stack, inventoryPlayer.field_70458_d.field_70170_p)) continue;
            climateScreens.add((Object)stack);
        }
        return climateScreens;
    }
}

