/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology.entities;

import javax.annotation.Nullable;
import java.util.List;

import forestry.api.lepidopterology.IButterflyNursery;
import forestry.core.utils.GeneticsUtil;
import forestry.lepidopterology.PluginLepidopterology;

public class AIButterflyMate extends AIButterflyInteract {
	@Nullable
	private EntityButterfly targetMate;

	public AIButterflyMate(EntityButterfly entity) {
		super(entity);
	}

	@Override
	protected boolean canInteract() {
		if (entity.getButterfly().getMate() == null && entity.canMate()) {
			return true;
		}
		if (entity.cooldownEgg > 0) {
			return false;
		}

		if (entity.getButterfly().getMate() == null) {
			return false;
		}

		if (entity.field_70170_p.func_72907_a(EntityButterfly.class) > PluginLepidopterology.spawnConstraint) {
			return false;
		}

		return rest != null && GeneticsUtil.canNurse(entity.getButterfly(), entity.field_70170_p, rest);
	}

	@Override
	public void func_75246_d() {
		if (func_75253_b()) {
			if (entity.getButterfly().getMate() == null && targetMate != null) {
				if (entity.cooldownMate <= 0 && entity.func_70068_e(targetMate) < 9.0D) {
					entity.getButterfly().mate(targetMate.getButterfly());
					targetMate.getButterfly().mate(entity.getButterfly());
					entity.cooldownMate = EntityButterfly.COOLDOWNS;
				}
			} else if (rest != null) {
				IButterflyNursery nursery = GeneticsUtil.getOrCreateNursery(null, entity.field_70170_p, rest, false);
				if (nursery != null) {
					if (nursery.canNurse(entity.getButterfly())) {
						nursery.setCaterpillar(entity.getButterfly().spawnCaterpillar(entity.field_70170_p, nursery));
						//Log.finest("A butterfly '%s' laid an egg at %s/%s/%s.", entity.getButterfly().getIdent(), rest.posX, rest.posY, rest.posZ);
						if (entity.func_70681_au().nextFloat() < 1.0f / entity.getButterfly().getGenome().getFertility()) {
							entity.func_70606_j(0);
						}
					}
				}
				setHasInteracted();
				entity.cooldownEgg = EntityButterfly.COOLDOWNS;
			}
		}
	}

	@Override
	public boolean func_75250_a() {
		if (!super.func_75250_a()) {
			return false;
		}
		if (entity.getButterfly().getMate() == null) {
			if (!entity.canMate()) {
				return false;
			} else {
				targetMate = getNearbyMate();
				return targetMate != null;
			}
		}
		return true;
	}

	@Override
	public boolean func_75253_b() {
		if (!super.func_75253_b()) {
			return false;
		}
		if (entity.getButterfly().getMate() == null) {
			return targetMate != null && targetMate.func_70089_S() && targetMate.canMate();
		}
		return true;
	}

	@Override
	public void func_75251_c() {
		super.func_75251_c();

		targetMate = null;
	}

	@Nullable
	private EntityButterfly getNearbyMate() {
		float f = 8.0F;
		List<EntityButterfly> nextButterflys = entity.field_70170_p.func_72872_a(EntityButterfly.class, this.entity.func_174813_aQ().func_72321_a(f, f, f));
		double d0 = Double.MAX_VALUE;
		EntityButterfly nextButterfly = null;

		for (EntityButterfly butterfly : nextButterflys) {
			if (this.entity.canMateWith(butterfly) && this.entity.func_70068_e(butterfly) < d0) {
				nextButterfly = butterfly;
				d0 = this.entity.func_70068_e(butterfly);
			}
		}

		return nextButterfly;
	}
}
