/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.fermenter;

import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IVariableFermentable;
import forestry.api.recipes.RecipeManagers;
import forestry.core.utils.Log;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class FermenterRecipeMaker {
    private FermenterRecipeMaker() {
    }

    public static List<FermenterRecipeWrapper> getFermenterRecipes(IStackHelper stackHelper) {
        ArrayList<FermenterRecipeWrapper> recipes = new ArrayList<FermenterRecipeWrapper>();
        for (IFermenterRecipe recipe : RecipeManagers.fermenterManager.recipes()) {
            if (!recipe.getResource().func_190926_b()) {
                FermenterRecipeMaker.addWrapperToList(stackHelper, recipe, recipe.getResource(), recipes);
                continue;
            }
            if (recipe.getResourceOreName() != null) {
                NonNullList itemStacks = OreDictionary.getOres((String)recipe.getResourceOreName());
                if (itemStacks.isEmpty()) continue;
                for (ItemStack resource : itemStacks) {
                    FermenterRecipeMaker.addWrapperToList(stackHelper, recipe, resource, recipes);
                }
                continue;
            }
            Log.error("Empty resource for recipe", new Object[0]);
        }
        return recipes;
    }

    private static void addWrapperToList(IStackHelper stackHelper, IFermenterRecipe recipe, ItemStack resource, List<FermenterRecipeWrapper> recipes) {
        if (resource.func_77973_b() instanceof IVariableFermentable) {
            for (ItemStack stack : stackHelper.getSubtypes(resource)) {
                recipes.add(new FermenterRecipeWrapper(recipe, stack));
            }
        } else {
            recipes.add(new FermenterRecipeWrapper(recipe, resource));
        }
    }
}

