/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import com.google.common.base.MoreObjects;
import forestry.api.climate.ClimateStateType;
import forestry.api.climate.IClimateState;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.NBTTagCompound;

@Immutable
public final class AbsentClimateState
implements IClimateState {
    public static final AbsentClimateState INSTANCE = new AbsentClimateState();

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("ABSENT", true);
        return compound;
    }

    @Override
    public IClimateState copy(ClimateStateType type) {
        return this;
    }

    @Override
    public IClimateState copy() {
        return this;
    }

    @Override
    public IClimateState addTemperature(float temperature) {
        return this;
    }

    @Override
    public IClimateState addHumidity(float humidity) {
        return this;
    }

    @Override
    public IClimateState add(IClimateState state) {
        return this;
    }

    @Override
    public IClimateState scale(double factor) {
        return this;
    }

    @Override
    public IClimateState remove(IClimateState state) {
        return this;
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public ClimateStateType getType() {
        return ClimateStateType.DEFAULT;
    }

    @Override
    public float getTemperature() {
        return Float.NaN;
    }

    @Override
    public float getHumidity() {
        return Float.NaN;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IClimateState)) {
            return false;
        }
        IClimateState otherState = (IClimateState)obj;
        return Float.isNaN(otherState.getTemperature()) && Float.isNaN(otherState.getHumidity());
    }

    public int hashCode() {
        return Float.hashCode(Float.NaN) * 31 + Float.hashCode(Float.NaN);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("temperature", Float.NaN).add("humidity", Float.NaN).toString();
    }
}

