/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import forestry.mail.tiles.TileTrader;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PacketTraderAddressRequest
extends ForestryPacket
implements IForestryPacketServer {
    private final BlockPos pos;
    private final String addressName;

    public PacketTraderAddressRequest(TileTrader tile, String addressName) {
        this.pos = tile.func_174877_v();
        this.addressName = addressName;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.TRADING_ADDRESS_REQUEST;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.func_180714_a(this.addressName);
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) throws IOException {
            BlockPos pos = data.func_179259_c();
            String addressName = data.readString();
            TileUtil.actOnTile((IBlockAccess)player.field_70170_p, pos, TileTrader.class, tile -> tile.handleSetAddressRequest(addressName));
        }
    }
}

