/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate;

import forestry.api.climate.ClimateStateType;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.api.core.ForestryAPI;
import forestry.api.greenhouse.IClimateHousing;
import forestry.core.climate.AbsentClimateState;
import forestry.core.climate.ClimateStates;
import forestry.core.config.Config;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketUpdateClimate;
import forestry.core.utils.NetworkUtil;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.climate.IClimateModifier;
import forestry.greenhouse.api.climate.IClimateSource;
import forestry.greenhouse.climate.GreenhouseClimateManager;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClimateContainer
implements IClimateContainer,
IStreamable {
    protected final IClimateHousing parent;
    protected final Set<IClimateSource> sources;
    protected final Supplier<Boolean> canWork;
    private int delay;
    protected IClimateState state;
    protected IClimateState targetedState;
    protected IClimateState boundaryUp;
    protected IClimateState boundaryDown;
    protected double sizeModifier;
    private NBTTagCompound modifierData;

    public ClimateContainer(IClimateHousing parent) {
        this(parent, () -> true);
    }

    public ClimateContainer(IClimateHousing parent, Supplier<Boolean> canWork) {
        this.parent = parent;
        this.sources = new HashSet<IClimateSource>();
        this.delay = 20;
        this.state = parent.getDefaultClimate().copy();
        this.modifierData = new NBTTagCompound();
        this.boundaryUp = ClimateStates.INSTANCE.min();
        this.boundaryDown = ClimateStates.INSTANCE.min();
        this.targetedState = AbsentClimateState.INSTANCE;
        this.canWork = canWork;
        this.sizeModifier = 1.0;
    }

    @Override
    public IClimateHousing getParent() {
        return this.parent;
    }

    @Override
    public void updateClimate(int ticks) {
        if (ticks % this.getTickDelay() == 0) {
            IClimateState oldState = this.state.copy(ClimateStateType.DEFAULT);
            this.state = this.parent.getDefaultClimate().copy(ClimateStateType.EXTENDED);
            for (IClimateModifier modifier : GreenhouseClimateManager.getInstance().getModifiers()) {
                this.state = modifier.modifyTarget(this, this.state, oldState, this.modifierData).copy(ClimateStateType.EXTENDED);
            }
            if (!this.state.equals(oldState)) {
                BlockPos coordinates = this.parent.getCoordinates();
                NetworkUtil.sendNetworkPacket(new PacketUpdateClimate(coordinates, this), coordinates, this.parent.getWorldObj());
            }
        }
    }

    @Override
    public double getSizeModifier() {
        return this.sizeModifier;
    }

    @Override
    public void recalculateBoundaries() {
        this.sizeModifier = Math.max((double)(this.parent.getSize() / Config.climateSourceRange), 1.0);
        float temperatureBoundaryUp = 0.0f;
        float humidityBoundaryUp = 0.0f;
        float temperatureBoundaryDown = 0.0f;
        float humidityBoundaryDown = 0.0f;
        for (IClimateSource source : this.sources) {
            if (source.affectClimateType(ClimateType.HUMIDITY)) {
                humidityBoundaryUp += source.getBoundaryModifier(ClimateType.HUMIDITY, true);
                humidityBoundaryDown += source.getBoundaryModifier(ClimateType.HUMIDITY, false);
            }
            if (!source.affectClimateType(ClimateType.TEMPERATURE)) continue;
            temperatureBoundaryUp += source.getBoundaryModifier(ClimateType.TEMPERATURE, true);
            temperatureBoundaryDown += source.getBoundaryModifier(ClimateType.TEMPERATURE, false);
        }
        if (temperatureBoundaryUp != 0.0f) {
            temperatureBoundaryUp = (float)((double)temperatureBoundaryUp / this.sizeModifier);
        }
        if (temperatureBoundaryDown != 0.0f) {
            temperatureBoundaryDown = (float)((double)temperatureBoundaryDown / this.sizeModifier);
        }
        if (humidityBoundaryUp != 0.0f) {
            humidityBoundaryUp = (float)((double)humidityBoundaryUp / this.sizeModifier);
        }
        if (humidityBoundaryDown != 0.0f) {
            humidityBoundaryDown = (float)((double)humidityBoundaryDown / this.sizeModifier);
        }
        this.boundaryUp = this.parent.getDefaultClimate().add(ClimateStates.of(temperatureBoundaryUp, humidityBoundaryUp));
        this.boundaryDown = this.parent.getDefaultClimate().remove(ClimateStates.of(temperatureBoundaryDown, humidityBoundaryDown));
    }

    @Override
    public IClimateState getBoundaryDown() {
        return this.boundaryDown;
    }

    @Override
    public IClimateState getBoundaryUp() {
        return this.boundaryUp;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        this.state.writeToNBT(nbt);
        nbt.func_74782_a("Target", (NBTBase)this.targetedState.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("modifierData", (NBTBase)this.modifierData);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.state = ForestryAPI.states.create(nbt);
        this.targetedState = ForestryAPI.states.create(nbt.func_74775_l("Target"));
        this.modifierData = nbt.func_74775_l("modifierData");
    }

    @Override
    public void setTargetedState(IClimateState state) {
        this.targetedState = state;
    }

    @Override
    public IClimateState getTargetedState() {
        return this.targetedState;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getTickDelay() {
        return this.delay;
    }

    public void setState(IClimateState state) {
        this.state = state;
    }

    @Override
    public World getWorld() {
        return this.parent.getWorldObj();
    }

    @Override
    public void addClimateSource(IClimateSource source) {
        if (!this.sources.contains(source)) {
            this.sources.add(source);
        }
    }

    @Override
    public void removeClimateSource(IClimateSource source) {
        if (this.sources.contains(source)) {
            this.sources.remove(source);
        }
    }

    @Override
    public Collection<IClimateSource> getClimateSources() {
        return this.sources;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeClimateState(this.state);
        data.writeClimateState(this.boundaryUp);
        data.writeClimateState(this.boundaryDown);
        data.writeClimateState(this.targetedState);
        data.func_150786_a(this.modifierData);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        this.state = data.readClimateState();
        this.boundaryUp = data.readClimateState();
        this.boundaryDown = data.readClimateState();
        this.targetedState = data.readClimateState();
        this.modifierData = data.func_150793_b();
    }

    @Override
    public IClimateState getState() {
        return this.state;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IClimateContainer)) {
            return false;
        }
        IClimateContainer container = (IClimateContainer)obj;
        IClimateHousing parent = container.getParent();
        if (parent.getCoordinates() == null || this.parent.getCoordinates() == null) {
            return false;
        }
        return this.parent.getCoordinates().equals((Object)parent.getCoordinates());
    }

    public int hashCode() {
        return this.parent.getCoordinates().hashCode();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addModifierInformation(IClimateModifier modifier, ClimateType type, List<String> lines) {
        if (!modifier.canModify(type)) {
            return;
        }
        modifier.addInformation(this, this.modifierData, type, lines);
    }

    @Override
    public boolean canWork() {
        return this.canWork.get();
    }
}

