/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.commands.TreeGenHelper;
import forestry.core.utils.BlockUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TreeDecorator {
    private static final List<IAlleleTreeSpecies> SPECIES = new ArrayList<IAlleleTreeSpecies>();
    private static final Map<ResourceLocation, Set<ITree>> biomeCache = new HashMap<ResourceLocation, Set<ITree>>();

    @SubscribeEvent
    public void decorateTrees(DecorateBiomeEvent.Decorate event) {
        if (event.getType() == DecorateBiomeEvent.Decorate.EventType.TREE) {
            TreeDecorator.decorateTrees(event.getWorld(), event.getRand(), event.getPos().func_177958_n() + 8, event.getPos().func_177952_p() + 8);
        }
    }

    public static void decorateTrees(World world, Random rand, int worldX, int worldZ) {
        if (biomeCache.isEmpty()) {
            TreeDecorator.generateBiomeCache(world, rand);
        }
        for (int tries = 0; tries < 4 + rand.nextInt(2); ++tries) {
            int x = worldX + rand.nextInt(16);
            int z = worldZ + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, 0, z);
            Biome biome = world.func_180494_b(pos);
            Set trees = biomeCache.computeIfAbsent(biome.getRegistryName(), k -> new HashSet());
            for (ITree tree : trees) {
                IAlleleTreeSpecies species = tree.getGenome().getPrimary();
                if (!(species.getRarity() >= rand.nextFloat()) || (pos = TreeDecorator.getValidPos(world, x, z, tree)) == null || !species.getGrowthProvider().canSpawn(tree, world, pos) || !TreeGenHelper.generateTree(tree, world, pos)) continue;
                return;
            }
        }
    }

    @Nullable
    private static BlockPos getValidPos(World world, int x, int z, ITree tree) {
        BlockPos topPos = world.func_175645_m(new BlockPos(x, 0, z));
        if (topPos.func_177956_o() == 0) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(topPos);
        IBlockState blockState = world.func_180495_p((BlockPos)pos);
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        while (BlockUtil.canReplace(blockState, world, (BlockPos)pos)) {
            pos.func_189536_c(EnumFacing.DOWN);
            if (pos.func_177956_o() <= 0) {
                return null;
            }
            blockState = world.func_180495_p((BlockPos)pos);
            downState = world.func_180495_p(pos.func_177977_b());
        }
        if (tree instanceof IPlantable && blockState.func_177230_c().canSustainPlant(blockState, (IBlockAccess)world, (BlockPos)pos, EnumFacing.UP, (IPlantable)tree)) {
            return pos.func_177984_a();
        }
        return null;
    }

    private static List<IAlleleTreeSpecies> getSpecies() {
        if (!SPECIES.isEmpty()) {
            return SPECIES;
        }
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles(EnumTreeChromosome.SPECIES)) {
            IAlleleTreeSpecies alleleTreeSpecies;
            if (!(allele instanceof IAlleleTreeSpecies) || !((alleleTreeSpecies = (IAlleleTreeSpecies)allele).getRarity() > 0.0f)) continue;
            SPECIES.add(alleleTreeSpecies);
        }
        return SPECIES;
    }

    private static void generateBiomeCache(World world, Random rand) {
        for (IAlleleTreeSpecies species : TreeDecorator.getSpecies()) {
            IAllele[] template = TreeManager.treeRoot.getTemplate(species);
            ITreeGenome genome = TreeManager.treeRoot.templateAsGenome(template);
            ITree tree = TreeManager.treeRoot.getTree(world, genome);
            IGrowthProvider growthProvider = species.getGrowthProvider();
            for (Biome biome : Biome.field_185377_q) {
                Set trees = biomeCache.computeIfAbsent(biome.getRegistryName(), k -> new HashSet());
                if (!growthProvider.isBiomeValid(tree, biome)) continue;
                trees.add(tree);
            }
        }
    }

    private static final class BiomeCache {
        protected final Biome biome;
        protected final List<ITree> validTrees;

        public BiomeCache(Biome biome, List<ITree> validTrees) {
            this.biome = biome;
            this.validTrees = validTrees;
        }
    }
}

