/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.charcoal.jei;

import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.charcoal.jei.CharcoalPileWallWrapper;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryTooltipCallback;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CharcoalPileWallCategory
extends ForestryRecipeCategory<CharcoalPileWallWrapper> {
    private final IDrawableStatic slot;
    private final IDrawableStatic arrow;
    private final IDrawableAnimated arrowAnimated;
    private final IDrawableStatic flame;
    private final IDrawableAnimated flameAnimated;

    public CharcoalPileWallCategory(IGuiHelper helper) {
        super((IDrawable)helper.createBlankDrawable(120, 38), "tile.for.charcoal.pile.wall.name");
        ResourceLocation resourceLocation = new ResourceLocation("forestry", "textures/gui/jei/charcoal_pile_wall.png");
        this.arrow = helper.createDrawable(resourceLocation, 0, 14, 22, 16);
        IDrawableStatic arrowAnimated = helper.createDrawable(resourceLocation, 22, 14, 22, 16);
        this.arrowAnimated = helper.createAnimatedDrawable(arrowAnimated, 160, IDrawableAnimated.StartDirection.LEFT, false);
        this.flame = helper.createDrawable(resourceLocation, 0, 0, 14, 14);
        IDrawableStatic flameAnimated = helper.createDrawable(resourceLocation, 14, 0, 14, 14);
        this.flameAnimated = helper.createAnimatedDrawable(flameAnimated, 260, IDrawableAnimated.StartDirection.TOP, true);
        this.slot = helper.getSlotDrawable();
    }

    public String getUid() {
        return "forestry.charcoal.pile";
    }

    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 52, 0);
        this.flameAnimated.draw(minecraft, 52, 0);
        this.arrow.draw(minecraft, 50, 16);
        this.arrowAnimated.draw(minecraft, 50, 16);
        this.slot.draw(minecraft, 0, 16);
        this.slot.draw(minecraft, 20, 16);
        this.slot.draw(minecraft, 84, 16);
        this.slot.draw(minecraft, 104, 16);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CharcoalPileWallWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        itemStackGroup.init(0, true, 0, 16);
        itemStackGroup.init(1, true, 20, 16);
        itemStackGroup.init(2, false, 84, 16);
        itemStackGroup.init(3, false, 104, 16);
        itemStackGroup.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        itemStackGroup.set(1, new ItemStack((Block)PluginArboriculture.getBlocks().woodPile));
        itemStackGroup.set(2, (List)ingredients.getOutputs(ItemStack.class).get(0));
        itemStackGroup.set(3, (List)ingredients.getOutputs(ItemStack.class).get(1));
        ForestryTooltipCallback tooltip = new ForestryTooltipCallback();
        tooltip.addFortuneTooltip(2);
        tooltip.addFortuneTooltip(3);
        itemStackGroup.addTooltipCallback((ITooltipCallback)tooltip);
    }
}

