/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.multiblock;

import net.minecraft.util.math.BlockPos;

import forestry.greenhouse.api.greenhouse.Position2D;

public class GreenhouseLimitsBuilder {
	public BlockPos.MutableBlockPos maximumCoordinates;
	public BlockPos.MutableBlockPos minimumCoordinates;

	public GreenhouseLimitsBuilder() {
		this.maximumCoordinates = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
		this.minimumCoordinates = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
	}

	public void recalculate(BlockPos position) {
		if (position.func_177958_n() < minimumCoordinates.func_177958_n()) {
			minimumCoordinates.func_181079_c(position.func_177958_n(), minimumCoordinates.func_177956_o(), minimumCoordinates.func_177952_p());
		}
		if (position.func_177958_n() > maximumCoordinates.func_177958_n()) {
			maximumCoordinates.func_181079_c(position.func_177958_n(), maximumCoordinates.func_177956_o(), maximumCoordinates.func_177952_p());
		}
		if (position.func_177956_o() < minimumCoordinates.func_177956_o()) {
			minimumCoordinates.func_181079_c(minimumCoordinates.func_177958_n(), position.func_177956_o(), minimumCoordinates.func_177952_p());
		}
		if (position.func_177956_o() > maximumCoordinates.func_177956_o()) {
			maximumCoordinates.func_181079_c(maximumCoordinates.func_177958_n(), position.func_177956_o(), maximumCoordinates.func_177952_p());
		}
		if (position.func_177952_p() < minimumCoordinates.func_177952_p()) {
			minimumCoordinates.func_181079_c(minimumCoordinates.func_177958_n(), minimumCoordinates.func_177956_o(), position.func_177952_p());
		}
		if (position.func_177952_p() > maximumCoordinates.func_177952_p()) {
			maximumCoordinates.func_181079_c(maximumCoordinates.func_177958_n(), maximumCoordinates.func_177956_o(), position.func_177952_p());
		}
	}

	public GreenhouseLimits build(int height, int depth) {
		return new GreenhouseLimits(new Position2D(maximumCoordinates), new Position2D(minimumCoordinates), height, depth);
	}
}
