/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks;

import forestry.greenhouse.multiblock.blocks.world.ChunkThread;
import forestry.greenhouse.multiblock.blocks.world.GreenhouseBlockManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChunkEvents {
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (GreenhouseBlockManager.getThread() == null || !GreenhouseBlockManager.getThread().isAlive()) {
            Thread climateThread = new Thread((Runnable)new ChunkThread(false), "Forestry Greenhouse");
            GreenhouseBlockManager.setThread(climateThread, false);
            climateThread.start();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (GreenhouseBlockManager.getClientThread() == null || !GreenhouseBlockManager.getClientThread().isAlive()) {
            Thread climateThread = new Thread((Runnable)new ChunkThread(true), "Forestry Greenhouse Client");
            GreenhouseBlockManager.setThread(climateThread, true);
            climateThread.start();
        }
    }

    @SubscribeEvent
    public void loadChunk(ChunkEvent.Load event) {
        Chunk chunk = event.getChunk();
        World world = event.getWorld();
        GreenhouseBlockManager manager = GreenhouseBlockManager.getInstance();
        manager.loadChunk(world, chunk.field_76635_g, chunk.field_76647_h);
    }

    @SubscribeEvent
    public void unloadChunk(ChunkEvent.Unload event) {
        Chunk chunk = event.getChunk();
        World world = event.getWorld();
        GreenhouseBlockManager manager = GreenhouseBlockManager.getInstance();
        manager.unloadChunk(world, chunk.field_76635_g, chunk.field_76647_h);
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        GreenhouseBlockManager manager = GreenhouseBlockManager.getInstance();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        manager.markBlockDirty(world, pos);
    }

    @SubscribeEvent
    public void placeBlock(BlockEvent.PlaceEvent event) {
        GreenhouseBlockManager manager = GreenhouseBlockManager.getInstance();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        manager.markBlockDirty(world, pos);
    }

    @SubscribeEvent
    public void multiPlaceBlock(BlockEvent.MultiPlaceEvent event) {
        GreenhouseBlockManager manager = GreenhouseBlockManager.getInstance();
        World world = event.getWorld();
        for (BlockSnapshot snapshot : event.getReplacedBlockSnapshots()) {
            BlockPos pos = snapshot.getPos();
            manager.markBlockDirty(world, pos);
        }
    }
}

