/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.items;

import forestry.api.climate.IClimateState;
import forestry.api.core.EnumTemperature;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemForestry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import forestry.greenhouse.PluginGreenhouse;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGreenhouseScreen
extends ItemForestry
implements IColoredItem {
    public static final String GREENHOUSE_KEY = "greenhouse";
    public static final String PREVIEW_KEY = "preview";

    public ItemGreenhouseScreen() {
        this.func_77637_a(PluginGreenhouse.getGreenhouseTab());
    }

    public static boolean isPreviewModeActive(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null || !nbtTagCompound.func_74764_b(PREVIEW_KEY)) {
            return false;
        }
        return nbtTagCompound.func_74767_n(PREVIEW_KEY);
    }

    public static void setPreviewMode(ItemStack itemStack, boolean preview) {
        itemStack.func_77983_a(PREVIEW_KEY, (NBTBase)new NBTTagByte((byte)(preview ? 1 : 0)));
    }

    @Nullable
    public static BlockPos getGreenhousePos(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null || !nbtTagCompound.func_74764_b(GREENHOUSE_KEY)) {
            return null;
        }
        NBTTagCompound compound = nbtTagCompound.func_74775_l(GREENHOUSE_KEY);
        if (compound.func_82582_d()) {
            return null;
        }
        return NBTUtil.func_186861_c((NBTTagCompound)compound);
    }

    public static boolean hasGreenhousePos(ItemStack itemStack) {
        return ItemGreenhouseScreen.getGreenhousePos(itemStack) != null;
    }

    public static boolean isValid(ItemStack stack, World world) {
        BlockPos pos = ItemGreenhouseScreen.getGreenhousePos(stack);
        boolean isValid = true;
        if (pos == null || world == null || !world.func_175667_e(pos)) {
            isValid = false;
        } else {
            IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController((IBlockAccess)world, pos, IGreenhouseComponent.class);
            if (controller == null || !controller.isAssembled()) {
                isValid = false;
            }
        }
        return isValid;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            boolean previewModeActive = ItemGreenhouseScreen.isPreviewModeActive(itemStack);
            ItemGreenhouseScreen.setPreviewMode(itemStack, !previewModeActive);
            if (world.field_72995_K) {
                player.func_146105_b((ITextComponent)(!previewModeActive ? new TextComponentTranslation("for.message.greenhouse_screen.preview.active", new Object[0]) : new TextComponentTranslation("for.message.greenhouse_screen.preview.inactive", new Object[0])), true);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        BlockPos itemPos = ItemGreenhouseScreen.getGreenhousePos(itemStack);
        if (!player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        return this.handleSneaking(world, pos, player, itemStack, itemPos);
    }

    private EnumActionResult handleSneaking(World world, BlockPos pos, EntityPlayer player, ItemStack itemStack, BlockPos itemPos) {
        IGreenhouseComponent component = MultiblockUtil.getComponent((IBlockAccess)world, pos, IGreenhouseComponent.class);
        if (component != null) {
            IGreenhouseController controller = component.getMultiblockLogic().getController();
            if (!controller.isAssembled()) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("for.message.greenhouse_screen.notassembled", new Object[0]), true);
                }
                return EnumActionResult.PASS;
            }
            itemStack.func_77983_a(GREENHOUSE_KEY, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("for.message.greenhouse_screen.position", new Object[0]), true);
            }
        } else {
            if (itemPos == null) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("for.message.greenhouse_screen.fail", new Object[0]), true);
                }
                return EnumActionResult.PASS;
            }
            if (!world.func_175667_e(pos)) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("for.message.greenhouse_screen.away", new Object[0]), true);
                }
                return EnumActionResult.PASS;
            }
            IGreenhouseController controller = (IGreenhouseController)MultiblockUtil.getController((IBlockAccess)world, itemPos, IGreenhouseComponent.class);
            if (controller == null || !controller.isAssembled()) {
                return EnumActionResult.PASS;
            }
            controller.setCenterCoordinates(pos);
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("for.message.greenhouse_screen.center", new Object[]{pos}), true);
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        boolean previewModeActive = ItemGreenhouseScreen.isPreviewModeActive(stack);
        String previewMode = Translator.translateToLocal(previewModeActive ? "for.greenhouse_screen.mode.active" : "for.greenhouse_screen.mode.inactive");
        tooltip.add(Translator.translateToLocal(Translator.translateToLocalFormatted("for.greenhouse_screen.mode", previewMode)));
        boolean isValid = ItemGreenhouseScreen.isValid(stack, world);
        BlockPos pos = ItemGreenhouseScreen.getGreenhousePos(stack);
        String state = isValid ? Translator.translateToLocalFormatted("for.greenhouse_screen.state.linked", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) : Translator.translateToLocal("for.greenhouse_screen.state.fail");
        tooltip.add(Translator.translateToLocalFormatted("for.greenhouse_screen.state", state));
        if (!isValid) {
            return;
        }
        IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController((IBlockAccess)world, pos, IGreenhouseComponent.class);
        IClimateState climateState = controller.getClimateContainer().getState();
        tooltip.add(Translator.translateToLocalFormatted("for.greenhouse_screen.temperature", TextFormatting.GOLD + StringUtil.floatAsPercent(climateState.getTemperature())));
        tooltip.add(Translator.translateToLocalFormatted("for.greenhouse_screen.humidity", TextFormatting.BLUE + StringUtil.floatAsPercent(climateState.getHumidity())));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        if (tintIndex == 2) {
            return ItemGreenhouseScreen.isValid(stack, (World)Minecraft.func_71410_x().field_71441_e) ? 1356406 : 12197655;
        }
        if (tintIndex == 1) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (!ItemGreenhouseScreen.isValid(stack, (World)world)) {
                return 0xFFFFFF;
            }
            BlockPos pos = ItemGreenhouseScreen.getGreenhousePos(stack);
            IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController((IBlockAccess)world, pos, IGreenhouseComponent.class);
            IClimateContainer container = controller.getClimateContainer();
            IClimateState state = container.getState();
            return ClimateUtil.getColor(EnumTemperature.getFromValue(state.getTemperature()));
        }
        return 0xFFFFFF;
    }
}

