/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.collect.LinkedListMultimap;
import forestry.core.IResupplyHandler;
import forestry.core.config.Config;
import forestry.core.worldgen.WorldGenerator;
import forestry.plugins.PluginManager;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickHandlerCoreServer {
    private final WorldGenerator worldGenerator;
    private final LinkedListMultimap<Integer, ChunkCoords> chunkRegenList = LinkedListMultimap.create();
    private final IntSet checkForRetrogen = new IntArraySet();

    public TickHandlerCoreServer(WorldGenerator worldGenerator) {
        this.worldGenerator = worldGenerator;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Config.enableBackpackResupply) {
            for (Object obj : event.world.field_73010_i) {
                EntityPlayer player = (EntityPlayer)obj;
                for (IResupplyHandler handler : PluginManager.resupplyHandlers) {
                    handler.resupply(player);
                }
            }
        }
        if (Config.doRetrogen && event.world instanceof WorldServer) {
            WorldServer world = (WorldServer)event.world;
            int dimensionID = world.field_73011_w.getDimension();
            if (this.checkForRetrogen.contains(dimensionID)) {
                List chunkList = this.chunkRegenList.get((Object)dimensionID);
                Iterator iterator = chunkList.iterator();
                while (iterator.hasNext()) {
                    ChunkCoords coords = (ChunkCoords)iterator.next();
                    if (!TickHandlerCoreServer.canDecorate(world, coords)) continue;
                    iterator.remove();
                    Random random = TickHandlerCoreServer.getRetrogenRandom((World)world, coords);
                    this.worldGenerator.retroGen(random, coords.x, coords.z, (World)world);
                }
                this.checkForRetrogen.remove(dimensionID);
            }
        }
    }

    private static Random getRetrogenRandom(World world, ChunkCoords coords) {
        long worldSeed = world.func_72905_C();
        Random random = new Random(worldSeed);
        long xSeed = random.nextLong() >> 3;
        long zSeed = random.nextLong() >> 3;
        random.setSeed(xSeed * (long)coords.x + zSeed * (long)coords.z ^ worldSeed);
        return random;
    }

    private static boolean canDecorate(WorldServer server, ChunkCoords chunkCoords) {
        ChunkProviderServer chunkProvider = server.func_72863_F();
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                if (chunkProvider.func_73149_a(chunkCoords.x + x, chunkCoords.z + z)) continue;
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public void chunkSaveEventHandler(ChunkDataEvent.Save event) {
        NBTTagCompound tag = new NBTTagCompound();
        if (Config.doRetrogen) {
            tag.func_74757_a("retrogen", true);
        }
        event.getData().func_74782_a("forestry", (NBTBase)tag);
    }

    @SubscribeEvent
    public void chunkLoadEventHandler(ChunkDataEvent.Load event) {
        NBTTagCompound tag;
        NBTTagCompound eventData;
        if (Config.doRetrogen && (eventData = event.getData()).func_74764_b("forestry") && (!(tag = (NBTTagCompound)eventData.func_74781_a("forestry")).func_74764_b("retrogen") || Config.forceRetrogen)) {
            ChunkCoords coords = new ChunkCoords(event.getChunk());
            this.chunkRegenList.put((Object)coords.dimension, (Object)coords);
            this.checkForRetrogen.add(coords.dimension);
        }
    }

    private static class ChunkCoords {
        public final int dimension;
        public final int x;
        public final int z;

        public ChunkCoords(Chunk chunk) {
            this.dimension = chunk.func_177412_p().field_73011_w.getDimension();
            this.x = chunk.field_76635_g;
            this.z = chunk.field_76647_h;
        }
    }
}

