/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.core.circuits.ISocketable;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileForestry;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.greenhouse.api.climate.IClimateSource;
import forestry.greenhouse.api.climate.IClimateSourceOwner;
import forestry.greenhouse.blocks.BlockClimatiser;
import forestry.greenhouse.camouflage.CamouflageHandlerType;
import forestry.greenhouse.climate.ClimateSource;
import forestry.greenhouse.climate.ClimateSourceClimatiser;
import forestry.greenhouse.climate.ClimateSourceType;
import forestry.greenhouse.gui.ContainerClimatiser;
import forestry.greenhouse.gui.GuiClimatiser;
import forestry.greenhouse.multiblock.GreenhouseController;
import forestry.greenhouse.network.packets.PacketCamouflageSelectionServer;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileClimatiser
extends TileForestry
implements IActivatable,
IStreamableGui,
IClimateSourceOwner,
ICamouflagedTile,
ICamouflageHandler,
ISocketable {
    public static final ClimatiserDefinition HEATER = new ClimatiserDefinition(0.075f, 5.0f, ClimateSourceType.TEMPERATURE);
    public static final ClimatiserDefinition FAN = new ClimatiserDefinition(-0.075f, 5.0f, ClimateSourceType.TEMPERATURE);
    public static final ClimatiserDefinition HUMIDIFIER = new ClimatiserDefinition(0.075f, 5.0f, ClimateSourceType.HUMIDITY);
    public static final ClimatiserDefinition DEHUMIDIFIER = new ClimatiserDefinition(-0.075f, 5.0f, ClimateSourceType.HUMIDITY);
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final ClimateSource source;
    private ItemStack camouflageBlock = this.getDefaultCamouflageBlock();
    private boolean active;

    public TileClimatiser(ClimatiserDefinition definition) {
        this(definition.change, definition.range, definition.type);
    }

    protected TileClimatiser(float change, float range, ClimateSourceType type) {
        this(new ClimateSourceClimatiser(type, change, range));
    }

    protected TileClimatiser(ClimateSource source) {
        this.source = source;
        this.source.setOwner(this);
    }

    @Override
    public ItemStack getCamouflageBlock() {
        return this.camouflageBlock;
    }

    @Override
    public ItemStack getDefaultCamouflageBlock() {
        return GreenhouseController.createDefaultCamouflageBlock();
    }

    @Override
    public boolean setCamouflageBlock(ItemStack camouflageBlock, boolean sendClientUpdate) {
        if (!ItemStackUtil.isIdenticalItem(camouflageBlock, this.camouflageBlock)) {
            this.camouflageBlock = camouflageBlock;
            if (sendClientUpdate && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                NetworkUtil.sendToServer(new PacketCamouflageSelectionServer(this, CamouflageHandlerType.TILE));
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175704_b(this.getCoordinates(), this.getCoordinates());
            } else {
                NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.getCoordinates(), this.field_145850_b);
            }
        }
    }

    public void onChunkUnload() {
        this.source.onChunkUnload();
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        this.source.invalidate();
        super.func_145843_s();
    }

    @Override
    protected void updateServerSide() {
        this.source.update();
        super.updateServerSide();
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        ICircuitBoard chipset;
        super.func_145839_a(data);
        if (data.func_74764_b("Camouflage")) {
            this.camouflageBlock = new ItemStack(data.func_74775_l("Camouflage"));
        }
        this.setActive(data.func_74767_n("Active"));
        this.sockets.readFromNBT(data);
        ItemStack chip = this.sockets.func_70301_a(0);
        if (!chip.func_190926_b() && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(chip)) != null) {
            chipset.onLoad(this);
        }
        this.source.readFromNBT(data);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        if (!this.camouflageBlock.func_190926_b()) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.camouflageBlock.func_77955_b(nbtTag);
            data.func_74782_a("Camouflage", (NBTBase)nbtTag);
        }
        data.func_74757_a("Active", this.active);
        this.sockets.writeToNBT(data);
        this.source.writeToNBT(data);
        return data;
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public String getUnlocalizedTitle() {
        Block block = this.func_145838_q();
        String blockUnlocalizedName = block.func_149739_a();
        if (block instanceof BlockClimatiser) {
            blockUnlocalizedName = blockUnlocalizedName + '.' + ((BlockClimatiser)block).getNameFromMeta(this.func_145832_p());
        }
        return blockUnlocalizedName + ".name";
    }

    @Override
    public IClimateSource getClimateSource() {
        return this.source;
    }

    @Override
    public boolean isCircuitable() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiClimatiser(player, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerClimatiser(player.field_71071_by, this);
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        this.sockets.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.sockets.readData(data);
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (!stack.func_190926_b() && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (!this.sockets.func_70301_a(slot).func_190926_b() && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(this.sockets.func_70301_a(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.func_70299_a(slot, stack);
        if (stack.func_190926_b()) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitBoard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return CircuitSocketType.GREENHOUSE_CLIMATISER;
    }

    public static class ClimatiserDefinition {
        float change;
        float range;
        ClimateSourceType type;

        public ClimatiserDefinition(float change, float range, ClimateSourceType type) {
            this.change = change;
            this.range = range;
            this.type = type;
        }
    }
}

