/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;

import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.multiblock.IGreenhouseComponent;
import forestry.core.multiblock.MultiblockUtil;
import forestry.greenhouse.api.greenhouse.IGreenhouseLimits;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.api.greenhouse.Position2D;
import forestry.greenhouse.items.ItemGreenhouseScreen;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;

@SideOnly(Side.CLIENT)
public class GreenhouseEventHandler {

	protected long previousCheckTick = 0;
	protected Set<BlockPos> greenhousePositions = new HashSet<>();

	@SubscribeEvent
	public void onWorldRenderLast(RenderWorldLastEvent event) {
		try {
			float partialTicks = event.getPartialTicks();
			EntityPlayer player = Minecraft.func_71410_x().field_71439_g;
			World world = player.field_70170_p;
			long tick = world.func_82737_E();
			if (tick > previousCheckTick + 50) {
				greenhousePositions.clear();
				for (ItemStack itemStack : getClimateScreen(player.field_71071_by)) {
					if (!itemStack.func_190926_b()) {
						BlockPos position = ItemGreenhouseScreen.getGreenhousePos(itemStack);
						IGreenhouseControllerInternal controller = MultiblockUtil.getController(world, position, IGreenhouseComponent.class);
						if (controller == null || !controller.isAssembled()) {
							return;
						}
						position = controller.getCenterCoordinates();
						double distance = MathHelper.func_76133_a(player.func_174831_c(position));
						if (distance > 64F) {
							return;
						}
						greenhousePositions.add(position);
					}
				}
				previousCheckTick = tick;
			}
			for (BlockPos position : greenhousePositions) {
				IGreenhouseControllerInternal controller = MultiblockUtil.getController(world, position, IGreenhouseComponent.class);
				if (controller == null || !controller.isAssembled()) {
					return;
				}
				IGreenhouseProvider provider = controller.getProvider();
				position = controller.getCenterCoordinates();
				double distance = MathHelper.func_76133_a(player.func_174831_c(position));
				if (distance > 64F) {
					return;
				}
				double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
				double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
				double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
				GlStateManager.func_179094_E();
				GlStateManager.func_179137_b(-playerX, -playerY, -playerZ);
				GlStateManager.func_179147_l();
				GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
				GlStateManager.func_179090_x();
				GlStateManager.func_187441_d(2.5F);
				IGreenhouseLimits limits = provider.getUsedLimits();
				if (limits != null) {
					Position2D minEdge = limits.getMinimumCoordinates();
					Position2D maxEdge = limits.getMaximumCoordinates();
					AxisAlignedBB greenhouseBB = new AxisAlignedBB(minEdge.getX(), limits.getDepth(), minEdge.getZ(), maxEdge.getX() + 1, limits.getHeight() + 1, maxEdge.getZ() + 1);
					RenderGlobal.func_189697_a(greenhouseBB, 0.0F, 0.0F, 0.0F, 0.5F);
				}
				//Draw center position
				BlockPos offset = provider.getCenterPos();
				AxisAlignedBB testBlockBB = Block.field_185505_j.func_186670_a(offset);
				RenderGlobal.func_189697_a(testBlockBB, 0.0F, 0.0F, 0.0F, 0.5F);
				GlStateManager.func_179098_w();
				GlStateManager.func_179084_k();
				GlStateManager.func_179121_F();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@SubscribeEvent
	public void onWorldLoad(WorldEvent.Load event) {
		previousCheckTick = 0;
	}

	private NonNullList<ItemStack> getClimateScreen(InventoryPlayer inventoryPlayer) {
		NonNullList<ItemStack> climateScreens = NonNullList.func_191196_a();
		List<ItemStack> items = NonNullList.func_191196_a();
		items.addAll(inventoryPlayer.field_70462_a);
		items.addAll(inventoryPlayer.field_184439_c);
		for (ItemStack stack : items) {
			if (stack.func_190926_b()) {
				continue;
			}
			if (stack.func_77973_b() != PluginGreenhouse.getItems().greenhouseScreen) {
				continue;
			}
			if (ItemGreenhouseScreen.isPreviewModeActive(stack) && ItemGreenhouseScreen.isValid(stack, inventoryPlayer.field_70458_d.field_70170_p)) {
				climateScreens.add(stack);
			}
		}
		return climateScreens;
	}

}
