/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.recipes.HygroregulatorRecipe;
import forestry.core.tiles.ILiquidTankTile;
import forestry.greenhouse.climate.ClimateSourceHygroregulator;
import forestry.greenhouse.gui.ContainerHygroregulator;
import forestry.greenhouse.gui.GuiHygroregulator;
import forestry.greenhouse.inventory.InventoryHygroregulator;
import forestry.greenhouse.tiles.TileClimatiser;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileHygroregulator
extends TileClimatiser
implements ILiquidTankTile {
    private final HygroregulatorRecipe[] recipes;
    private final TankManager tankManager;
    private final FilteredTank liquidTank;

    public TileHygroregulator() {
        super(new ClimateSourceHygroregulator(5.0f));
        this.setInternalInventory(new InventoryHygroregulator(this));
        Fluid water = FluidRegistry.WATER;
        Fluid lava = FluidRegistry.LAVA;
        Fluid liquidIce = Fluids.ICE.getFluid();
        this.liquidTank = new FilteredTank(10000).setFilters(water, lava, liquidIce);
        this.tankManager = new TankManager(this, this.liquidTank);
        this.recipes = new HygroregulatorRecipe[]{new HygroregulatorRecipe(new FluidStack(water, 1), 1, 0.05f, -0.005f), new HygroregulatorRecipe(new FluidStack(lava, 1), 10, -0.05f, 0.005f), new HygroregulatorRecipe(new FluidStack(liquidIce, 1), 10, 0.075f, -0.01f)};
    }

    public FilteredTank getLiquidTank() {
        return this.liquidTank;
    }

    @Override
    protected void updateServerSide() {
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 0);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public String getUnlocalizedTitle() {
        return "for.gui.greenhouse.hygroregulator.title";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiHygroregulator(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerHygroregulator(player.field_71071_by, this);
    }

    @Nullable
    public HygroregulatorRecipe getRecipe(FluidStack liquid) {
        HygroregulatorRecipe recipe = null;
        for (HygroregulatorRecipe rec : this.recipes) {
            if (!rec.liquid.isFluidEqual(liquid)) continue;
            recipe = rec;
            break;
        }
        return recipe;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return super.getCapability(capability, facing);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public HygroregulatorRecipe[] getRecipes() {
        return this.recipes;
    }
}

