/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate;

import forestry.api.climate.ClimateType;
import forestry.greenhouse.api.climate.IClimateSourceCircuitable;
import forestry.greenhouse.api.climate.IClimateSourceOwner;
import forestry.greenhouse.climate.ClimateSource;
import forestry.greenhouse.climate.ClimateSourceType;

public abstract class ClimateSourceCircuitable<O extends IClimateSourceOwner>
extends ClimateSource<O>
implements IClimateSourceCircuitable {
    protected float changeMultiplierTemperature = 1.0f;
    protected float rangeMultiplierTemperature = 1.0f;
    protected float changeMultiplierHumidity = 1.0f;
    protected float rangeMultiplierHumidity = 1.0f;
    protected float energyChange = 1.0f;

    public ClimateSourceCircuitable(float change, float range, ClimateSourceType sourceType) {
        super(change, range, sourceType);
    }

    @Override
    public void changeSourceConfig(ClimateType type, float changeChange, float rangeChange, float energyChange) {
        if (type == ClimateType.TEMPERATURE) {
            this.changeMultiplierTemperature += changeChange;
            this.rangeMultiplierTemperature += rangeChange;
        } else {
            this.changeMultiplierHumidity += changeChange;
            this.rangeMultiplierHumidity += rangeChange;
        }
        this.energyChange += energyChange;
    }

    public float getChangeMultiplier(ClimateType type) {
        float changeMultiplier = type == ClimateType.TEMPERATURE ? this.changeMultiplierTemperature : this.changeMultiplierHumidity;
        return changeMultiplier;
    }

    @Override
    protected float getRange(ClimateType type) {
        float rangeMultiplier = type == ClimateType.TEMPERATURE ? this.rangeMultiplierTemperature : this.rangeMultiplierHumidity;
        return super.getRange(type) * rangeMultiplier;
    }

    @Override
    protected float getChange(ClimateType type) {
        return super.getChange(type) * this.getChangeMultiplier(type);
    }
}

