/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate;

import forestry.api.climate.ClimateStateType;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.core.climate.ClimateStates;
import forestry.core.utils.Log;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.climate.IClimateSource;
import forestry.greenhouse.api.climate.IClimateSourceOwner;
import forestry.greenhouse.api.greenhouse.GreenhouseManager;
import forestry.greenhouse.climate.ClimateSourceMode;
import forestry.greenhouse.climate.ClimateSourceType;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class ClimateSource<O extends IClimateSourceOwner>
implements IClimateSource {
    protected final float range;
    protected final ClimateSourceType sourceType;
    protected O owner;
    private IClimateState state;
    protected float change;
    protected ClimateSourceMode temperatureMode;
    protected ClimateSourceMode humidityMode;
    protected IClimateContainer container;
    protected boolean addedToManager;
    protected boolean isActive;

    public ClimateSource(float change, float range, ClimateSourceType sourceType) {
        this.change = change;
        this.range = range;
        this.sourceType = sourceType;
        this.temperatureMode = ClimateSourceMode.NONE;
        this.humidityMode = ClimateSourceMode.NONE;
        this.state = ClimateStates.INSTANCE.absent();
    }

    public void setHumidityMode(ClimateSourceMode humidityMode) {
        this.humidityMode = humidityMode;
    }

    public void setTemperatureMode(ClimateSourceMode temperatureMode) {
        this.temperatureMode = temperatureMode;
    }

    public void setOwner(O owner) {
        this.owner = owner;
    }

    @Override
    public float getBoundaryModifier(ClimateType type, boolean boundaryUp) {
        if (type == ClimateType.HUMIDITY) {
            if (this.humidityMode == ClimateSourceMode.POSITIVE && boundaryUp) {
                return this.getRange(ClimateType.HUMIDITY);
            }
            if (this.humidityMode == ClimateSourceMode.NEGATIVE && !boundaryUp) {
                return this.getRange(ClimateType.HUMIDITY);
            }
        } else {
            if (this.temperatureMode == ClimateSourceMode.POSITIVE && boundaryUp) {
                return this.getRange(ClimateType.TEMPERATURE);
            }
            if (this.temperatureMode == ClimateSourceMode.NEGATIVE && !boundaryUp) {
                return this.getRange(ClimateType.TEMPERATURE);
            }
        }
        return 0.0f;
    }

    protected float getRange(ClimateType type) {
        return this.range;
    }

    protected float getChange(ClimateType type) {
        return this.change;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean affectClimateType(ClimateType type) {
        return this.sourceType.affectClimateType(type);
    }

    @Override
    public IClimateSourceOwner getOwner() {
        return this.owner;
    }

    @Override
    public void onAdded(IClimateContainer container) {
        this.container = container;
    }

    @Override
    public void onRemoved(IClimateContainer container) {
        this.container = null;
    }

    public void update() {
        if (!this.addedToManager) {
            this.onLoad();
        }
    }

    public void onLoad() {
        World world = this.owner.getWorldObj();
        if (!this.addedToManager && !world.field_72995_K) {
            GreenhouseManager.climateManager.addSource((IClimateSourceOwner)this.owner);
            this.addedToManager = true;
        }
    }

    public void invalidate() {
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        World world = this.owner.getWorldObj();
        if (this.addedToManager && !world.field_72995_K) {
            GreenhouseManager.climateManager.removeSource((IClimateSourceOwner)this.owner);
            this.addedToManager = false;
        }
    }

    @Override
    public final IClimateState work(IClimateState previousState, IClimateState targetState, IClimateState currentState, double sizeModifier, boolean canWork) {
        IClimateState state = ClimateStates.INSTANCE.create(this.getState(), ClimateStateType.EXTENDED);
        IClimateState change = ClimateStates.extendedZero();
        IClimateState defaultState = this.container.getParent().getDefaultClimate();
        ClimateSourceType validType = this.getWorkType(currentState, targetState);
        ClimateSourceType oppositeType = this.getOppositeWorkType(currentState, defaultState);
        this.beforeWork();
        boolean work = this.canWork(state, oppositeType);
        if (!canWork || !work && oppositeType != null) {
            this.isActive = false;
            this.isNotValid();
            if (ClimateStates.isZero(state)) {
                return change;
            }
            if (ClimateStates.isNearZero(state)) {
                this.setState(change);
                return change;
            }
            if (ClimateStates.isNearTarget(currentState, targetState)) {
                return change;
            }
            change = this.getChange(oppositeType, defaultState, currentState);
            change = ClimateStates.INSTANCE.create(-change.getTemperature(), -change.getHumidity(), ClimateStateType.EXTENDED);
        } else if (validType == null && oppositeType != null) {
            this.removeResources(state, oppositeType);
        } else {
            change = this.getChange(validType, targetState, previousState);
            IClimateState changedState = state.add(change.scale(1.0 / sizeModifier));
            boolean couldWork = this.canWork(changedState, oppositeType);
            this.removeResources(couldWork ? changedState : state, oppositeType);
            if (!couldWork) {
                change = ClimateStates.extendedZero();
            }
        }
        state.add(change.scale(1.0 / sizeModifier));
        if (ClimateStates.isZero(state) || ClimateStates.isNearZero(state)) {
            state = ClimateStates.extendedZero();
        }
        if (!state.isPresent()) {
            state = ClimateStates.extendedZero();
            Log.error("Failed to update a climate source. Please report this to the authors of the mod. Previous={}, Target={}, Current={}, Size={}", previousState, targetState, currentState, sizeModifier);
        }
        this.setState(state);
        return change;
    }

    protected void isNotValid() {
    }

    protected void beforeWork() {
    }

    protected abstract boolean canWork(IClimateState var1, ClimateSourceType var2);

    protected abstract void removeResources(IClimateState var1, ClimateSourceType var2);

    protected abstract IClimateState getChange(@Nullable ClimateSourceType var1, IClimateState var2, IClimateState var3);

    @Nullable
    protected ClimateSourceType getOppositeWorkType(IClimateState state, IClimateState target) {
        boolean canChangeTemperature;
        boolean canChangeHumidity = this.sourceType.canChangeHumidity() && this.canChange(state.getHumidity(), target.getHumidity(), this.humidityMode.getOpposite());
        boolean bl = canChangeTemperature = this.sourceType.canChangeTemperature() && this.canChange(state.getTemperature(), target.getTemperature(), this.temperatureMode.getOpposite());
        return canChangeHumidity ? (canChangeTemperature ? ClimateSourceType.BOTH : ClimateSourceType.HUMIDITY) : (canChangeTemperature ? ClimateSourceType.TEMPERATURE : null);
    }

    @Nullable
    protected ClimateSourceType getWorkType(IClimateState state, IClimateState target) {
        boolean canChangeTemperature;
        boolean canChangeHumidity = this.sourceType.canChangeHumidity() && this.canChange(state.getHumidity(), target.getHumidity(), this.humidityMode);
        boolean bl = canChangeTemperature = this.sourceType.canChangeTemperature() && this.canChange(state.getTemperature(), target.getTemperature(), this.temperatureMode);
        return canChangeHumidity ? (canChangeTemperature ? ClimateSourceType.BOTH : ClimateSourceType.HUMIDITY) : (canChangeTemperature ? ClimateSourceType.TEMPERATURE : null);
    }

    private boolean canChange(float value, float target, ClimateSourceMode mode) {
        if (mode == ClimateSourceMode.POSITIVE && value < target) {
            return true;
        }
        return mode == ClimateSourceMode.NEGATIVE && value > target;
    }

    @Override
    public IClimateState getState() {
        return this.state.copy();
    }

    protected void setState(IClimateState state) {
        this.state = state;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound sourceData = new NBTTagCompound();
        this.state.writeToNBT(sourceData);
        nbt.func_74782_a("Source", (NBTBase)sourceData);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound sourceData = nbt.func_74775_l("Source");
        if (sourceData.func_82582_d()) {
            return;
        }
        this.state = ClimateStates.INSTANCE.create(sourceData, ClimateStateType.EXTENDED);
    }
}

