/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IAlleleButterflySpeciesBuilder;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutationBuilder;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.utils.StringUtil;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.IButterflyDefinition;
import forestry.lepidopterology.genetics.MothDefinition;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.item.ItemStack;

public enum ButterflyDefinition implements IButterflyDefinition
{
    CabbageWhite(ButterflyBranchDefinition.Pieris, "cabbageWhite", "rapae", new Color(0xCCFFEE), true, 1.0f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    Brimstone(ButterflyBranchDefinition.Gonepteryx, "brimstone", "rhamni", new Color(15789624), true, 1.0f),
    Aurora(ButterflyBranchDefinition.Anthocharis, "orangeTip", "cardamines", new Color(14896901), true, 0.5f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.SMALLER);
        }
    }
    ,
    Postillion(ButterflyBranchDefinition.Colias, "postillion", "croceus", new Color(14122500), true, 0.5f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOW);
        }
    }
    ,
    PalaenoSulphur(ButterflyBranchDefinition.Colias, "palaenoSulphur", "palaeno", new Color(16317347), true, 0.4f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOWER);
        }
    }
    ,
    Reseda(ButterflyBranchDefinition.Pontia, "reseda", "edusa", new Color(7634248), true, 0.3f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOWER);
        }
    }
    ,
    SpringAzure(ButterflyBranchDefinition.Celastrina, "springAzure", "argiolus", new Color(12110562), true, 0.3f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.SMALLER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }
    }
    ,
    GozoraAzure(ButterflyBranchDefinition.Celastrina, "gozoraAzure", "gozora", new Color(6844647), true, 0.2f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.SMALLER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }
    }
    ,
    CitrusSwallow(ButterflyBranchDefinition.Papilio, "swallowtailC", "demodocus", new Color(15393673), false, 1.0f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGE);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.FERTILITY, 10);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.METABOLISM, 8);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    EmeraldPeacock(ButterflyBranchDefinition.Papilio, "emeraldPeacock", "palinurus", new Color(8191616), true, 0.1f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGE);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.FERTILITY, 5);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    ThoasSwallow(ButterflyBranchDefinition.Papilio, "swallowtailT", "thoas", new Color(15386499), false, 0.2f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGE);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
        }
    }
    ,
    Spicebush(ButterflyBranchDefinition.Papilio, "swallowtailS", "troilus", new Color(0xEEFEFF), true, 0.5f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    BlackSwallow(ButterflyBranchDefinition.Papilio, "swallowtailB", "polyxenes", new Color(15386499), true, 1.0f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOW);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGE);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    ZebraSwallow(ButterflyBranchDefinition.Protographium, "swallowtailZ", "marcellus", new Color(0xEAFEFF), true, 0.5f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    Glasswing(ButterflyBranchDefinition.Greta, "glasswing", "oto", new Color(5781298), true, 0.1f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.SMALLER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.FERTILITY, 5);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    SpeckledWood(ButterflyBranchDefinition.Pararge, "speckledWood", "aegeria", new Color(9728581), true, 1.0f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.FERTILITY, 2);
        }
    }
    ,
    MSpeckledWood(ButterflyBranchDefinition.Pararge, "speckledWoodM", "xiphia", new Color(4204825), true, 0.5f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.FERTILITY, 2);
        }
    }
    ,
    CSpeckledWood(ButterflyBranchDefinition.Pararge, "speckledWoodC", "xiphioides", new Color(5322538), true, 0.5f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.FERTILITY, 2);
        }
    }
    ,
    MBlueMorpho(ButterflyBranchDefinition.Morpho, "blueMorphoM", "menelaus", new Color(7528957), true, 0.5f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.FERTILITY, 2);
        }
    }
    ,
    PBlueMorpho(ButterflyBranchDefinition.Morpho, "blueMorphoP", "peleides", new Color(7261416), true, 0.25f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.FERTILITY, 2);
        }
    }
    ,
    RBlueMorpho(ButterflyBranchDefinition.Morpho, "blueMorphoR", "rhetenor", new Color(48888), true, 0.1f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.FERTILITY, 2);
        }
    }
    ,
    Comma(ButterflyBranchDefinition.Polygonia, "comma", "c-album", new Color(16291077), true, 0.3f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOWER);
        }
    }
    ,
    Batesia(ButterflyBranchDefinition.Batesia, "paintedBeauty", "hypochlora", new Color(16676707), true, 0.3f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGE);
        }
    }
    ,
    BlueWing(ButterflyBranchDefinition.Myscelia, "blueWing", "ethusa", new Color(3838924), true, 0.3f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.AVERAGE);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.METABOLISM, 5);
        }
    }
    ,
    Monarch(ButterflyBranchDefinition.Danaus, "monarch", "plexippus", new Color(16754466), true, 0.2f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    BlueDuke(ButterflyBranchDefinition.Bassarona, "blueDuke", "durga", new Color(3162688), true, 0.5f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.BOTH_1);
        }
    }
    ,
    GlassyTiger(ButterflyBranchDefinition.Parantica, "glassyTiger", "aglea", new Color(5978421), true, 0.3f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    Postman(ButterflyBranchDefinition.Heliconius, "postman", "melpomene", new Color(16199725), true, 0.3f),
    Malachite(ButterflyBranchDefinition.Siproeta, "malachite", "stelenes", new Color(12451667), true, 0.5f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.AVERAGE);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    LLacewing(ButterflyBranchDefinition.Cethosia, "leopardLacewing", "cyane", new Color(16484870), true, 0.7f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.UP_1);
        }
    }
    ,
    DianaFrit(ButterflyBranchDefinition.Speyeria, "dianaFritillary", "diana", new Color(16755717), true, 0.6f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.SMALLER);
        }
    };

    private final IAlleleButterflySpecies species;
    private final ButterflyBranchDefinition branch;
    private IAllele[] template;
    private IButterflyGenome genome;

    private ButterflyDefinition(ButterflyBranchDefinition branchDefinition, String speciesName, String binomial, Color serumColor, boolean dominant, float rarity) {
        this.branch = branchDefinition;
        String uid = "lepi" + this.name();
        IClassification parent = this.branch.getBranch().getParent();
        String unlocalizedName = "for.butterflies.species." + parent.getUID().substring(parent.getLevel().name().toLowerCase(Locale.ENGLISH).length() + 1) + '.' + speciesName;
        String unlocalizedDescription = "for.description." + uid;
        String texture = StringUtil.camelCaseToUnderscores("butterflies/" + uid);
        IAlleleButterflySpeciesBuilder speciesBuilder = ButterflyManager.butterflyFactory.createSpecies("forestry." + uid, unlocalizedName, "Sengir", unlocalizedDescription, "forestry", texture, dominant, branchDefinition.getBranch(), binomial, serumColor);
        speciesBuilder.setRarity(rarity);
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    public static void preInit() {
    }

    public static void initButterflies() {
        for (ButterflyDefinition butterfly : ButterflyDefinition.values()) {
            butterfly.init();
        }
        for (ButterflyDefinition butterfly : ButterflyDefinition.values()) {
            butterfly.registerMutations();
        }
    }

    private void init() {
        this.template = this.branch.getTemplate();
        AlleleHelper.getInstance().set(this.template, EnumButterflyChromosome.SPECIES, this.species);
        this.setAlleles(this.template);
        this.genome = ButterflyManager.butterflyRoot.templateAsGenome(this.template);
        ButterflyManager.butterflyRoot.registerTemplate(this.template);
    }

    protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
    }

    protected void setAlleles(IAllele[] alleles) {
    }

    protected void registerMutations() {
    }

    protected final IButterflyMutationBuilder registerMutation(IButterflyDefinition parent1, IButterflyDefinition parent2, int chance) {
        IAlleleButterflySpecies species2;
        IAlleleButterflySpecies species1;
        if (parent1 instanceof ButterflyDefinition) {
            species1 = ((ButterflyDefinition)parent1).species;
        } else if (parent1 instanceof MothDefinition) {
            species1 = ((MothDefinition)parent1).getSpecies();
        } else {
            throw new IllegalArgumentException("Unknown parent type " + parent1);
        }
        if (parent2 instanceof ButterflyDefinition) {
            species2 = ((ButterflyDefinition)parent2).species;
        } else if (parent2 instanceof MothDefinition) {
            species2 = ((MothDefinition)parent2).getSpecies();
        } else {
            throw new IllegalArgumentException("Unknown parent type " + parent2);
        }
        return ButterflyManager.butterflyMutationFactory.createMutation(species1, species2, this.getTemplate(), chance);
    }

    @Override
    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    @Override
    public final IButterflyGenome getGenome() {
        return this.genome;
    }

    @Override
    public final IButterfly getIndividual() {
        return new Butterfly(this.genome);
    }

    @Override
    public final ItemStack getMemberStack(EnumFlutterType flutterType) {
        IButterfly butterfly = this.getIndividual();
        return ButterflyManager.butterflyRoot.getMemberStack(butterfly, flutterType);
    }

    public IAlleleButterflySpecies getSpecies() {
        return this.species;
    }
}

