/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IHiveTile;
import forestry.apiculture.entities.ParticleBeeExplore;
import forestry.apiculture.entities.ParticleBeeRoundTrip;
import forestry.apiculture.entities.ParticleBeeTargetEntity;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.config.Config;
import forestry.core.entities.ParticleHoneydust;
import forestry.core.entities.ParticleIgnition;
import forestry.core.entities.ParticleSmoke;
import forestry.core.entities.ParticleSnow;
import forestry.core.utils.VectUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleRender {
    public static boolean shouldSpawnParticle(World world) {
        if (!Config.enableParticleFX) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int particleSetting = mc.field_71474_y.field_74362_aa;
        if (particleSetting == 2) {
            return world.field_73012_v.nextInt(10) == 0;
        }
        if (particleSetting == 1) {
            return world.field_73012_v.nextInt(3) != 0;
        }
        return true;
    }

    public static void addBeeHiveFX(IBeeHousing housing, IBeeGenome genome, List<BlockPos> flowerPositions) {
        List<EntityLivingBase> entitiesInRange;
        World world = housing.getWorldObj();
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Vec3d particleStart = housing.getBeeFXCoordinates();
        BlockPos playerPosition = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        double playerDistanceSq = playerPosition.func_177957_d(particleStart.field_72450_a, particleStart.field_72448_b, particleStart.field_72449_c);
        if ((double)world.field_73012_v.nextInt(1024) < playerDistanceSq) {
            return;
        }
        int color = genome.getPrimary().getSpriteColour(0);
        int randomInt = world.field_73012_v.nextInt(100);
        if (housing instanceof IHiveTile && (((IHiveTile)((Object)housing)).isAngry() || randomInt >= 85) && !(entitiesInRange = AlleleEffect.getEntitiesInRange(genome, housing, EntityLivingBase.class)).isEmpty()) {
            EntityLivingBase entity = entitiesInRange.get(world.field_73012_v.nextInt(entitiesInRange.size()));
            ParticleBeeTargetEntity particle = new ParticleBeeTargetEntity(world, particleStart, (Entity)entity, color);
            effectRenderer.func_78873_a((Particle)particle);
            return;
        }
        if (randomInt < 75 && !flowerPositions.isEmpty()) {
            BlockPos destination = flowerPositions.get(world.field_73012_v.nextInt(flowerPositions.size()));
            ParticleBeeRoundTrip particle = new ParticleBeeRoundTrip(world, particleStart, destination, color);
            effectRenderer.func_78873_a((Particle)particle);
        } else {
            Vec3i area = AlleleEffect.getModifiedArea(genome, housing);
            BlockPos offset = housing.getCoordinates().func_177982_a(-area.func_177958_n() / 2, -area.func_177956_o() / 4, -area.func_177952_p() / 2);
            BlockPos destination = VectUtil.getRandomPositionInArea(world.field_73012_v, area).func_177971_a((Vec3i)offset);
            ParticleBeeExplore particle = new ParticleBeeExplore(world, particleStart, destination, color);
            effectRenderer.func_78873_a((Particle)particle);
        }
    }

    public static void addEntityHoneyDustFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleHoneydust(world, x, y, z, 0.0f, 0.0f, 0.0f));
    }

    public static void addEntityExplodeFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Particle Particle2 = effectRenderer.func_178927_a(EnumParticleTypes.EXPLOSION_NORMAL.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[0]);
        effectRenderer.func_78873_a(Particle2);
    }

    public static void addEntitySnowFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleSnow(world, x + world.field_73012_v.nextGaussian(), y, z + world.field_73012_v.nextGaussian()));
    }

    public static void addEntityIgnitionFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleIgnition(world, x, y, z));
    }

    public static void addEntitySmokeFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleSmoke(world, x, y, z));
    }

    public static void addEntityPotionFX(World world, double x, double y, double z, int color) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Particle particle = effectRenderer.func_178927_a(EnumParticleTypes.SPELL.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[0]);
        if (particle != null) {
            particle.func_70538_b(red, green, blue);
            effectRenderer.func_78873_a(particle);
        }
    }
}

