/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IItemModelRegister;
import forestry.arboriculture.LeafDecayHelper;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.blocks.IColoredBlock;
import forestry.core.proxy.Proxies;
import forestry.core.utils.BlockUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockAbstractLeaves
extends BlockLeaves
implements IItemModelRegister,
IColoredBlock {
    private final ThreadLocal<NonNullList<ItemStack>> drops = new ThreadLocal();

    @Nullable
    protected abstract ITree getTree(IBlockAccess var1, BlockPos var2);

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        LeafDecayHelper.leafDecay(this, world, pos);
    }

    public abstract int func_176201_c(IBlockState var1);

    public abstract IBlockState func_176203_a(int var1);

    public final void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    public final ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ITree tree = this.getTree((IBlockAccess)world, pos);
        if (tree == null) {
            return ItemStack.field_190927_a;
        }
        return tree.getGenome().getDecorativeLeaves();
    }

    public final List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ItemStack decorativeLeaves;
        ITree tree = this.getTree(world, pos);
        if (tree == null) {
            tree = TreeDefinition.Oak.getIndividual();
        }
        if ((decorativeLeaves = tree.getGenome().getDecorativeLeaves()).func_190926_b()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(decorativeLeaves);
    }

    @Nullable
    public final AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        ITree tree = this.getTree(worldIn, pos);
        if (tree != null && TreeDefinition.Willow.getUID().equals(tree.getIdent())) {
            return null;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public final void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        entityIn.field_70159_w *= 0.4;
        entityIn.field_70179_y *= 0.4;
    }

    public final boolean func_149662_c(IBlockState state) {
        return !Proxies.render.fancyGraphicsEnabled();
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Proxies.render.fancyGraphicsEnabled() || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this) && BlockUtil.shouldSideBeRendered(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public final BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public final BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public final int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public final boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public final int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return 20;
        }
        if (face != EnumFacing.UP) {
            return 10;
        }
        return 5;
    }

    public final void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184607_cu());
        float saplingModifier = 1.0f;
        ItemStack heldStack = player.field_71071_by.func_70448_g();
        Item heldItem = heldStack.func_77973_b();
        if (heldItem instanceof IToolGrafter) {
            IToolGrafter grafter = (IToolGrafter)heldItem;
            saplingModifier = grafter.getSaplingModifier(heldStack, world, player, pos);
            heldStack.func_77972_a(1, (EntityLivingBase)player);
            if (heldStack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)heldStack, (EnumHand)EnumHand.MAIN_HAND);
            }
        }
        GameProfile playerProfile = player.func_146103_bH();
        NonNullList drops = NonNullList.func_191196_a();
        this.getLeafDrop((NonNullList<ItemStack>)drops, world, playerProfile, pos, saplingModifier, fortune);
        this.drops.set((NonNullList<ItemStack>)drops);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List ret = (List)this.drops.get();
        this.drops.remove();
        if (ret != null) {
            drops.addAll((Collection)ret);
        } else {
            this.getLeafDrop(drops, (World)world, null, pos, 1.0f, fortune);
        }
    }

    protected abstract void getLeafDrop(NonNullList<ItemStack> var1, World var2, @Nullable GameProfile var3, BlockPos var4, float var5, int var6);
}

