/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmRegistry;
import forestry.api.farming.IFarmable;
import forestry.api.farming.ISimpleFarmLogic;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.farming.logic.FarmLogicSimple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Property;

public final class FarmRegistry
implements IFarmRegistry {
    private static final FarmRegistry INSTANCE = new FarmRegistry();
    private final Multimap<String, IFarmable> farmables = HashMultimap.create();
    private final Map<ItemStack, Integer> fertilizers = new LinkedHashMap<ItemStack, Integer>();
    private final Map<String, IFarmLogic> logics = new HashMap<String, IFarmLogic>();

    public static FarmRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerFarmLogic(String identifier, IFarmLogic logic) {
        this.logics.put(identifier, logic);
    }

    public IFarmLogic getFarmLogic(String identifier) {
        return this.logics.get(identifier);
    }

    @Override
    public void registerFarmables(String identifier, IFarmable ... farmablesArray) {
        this.farmables.putAll((Object)identifier, Arrays.asList(farmablesArray));
    }

    @Override
    public Collection<IFarmable> getFarmables(String identifier) {
        return this.farmables.get((Object)identifier);
    }

    @Override
    public IFarmLogic createLogic(ISimpleFarmLogic simpleFarmLogic) {
        return new FarmLogicSimple(simpleFarmLogic);
    }

    @Override
    public void registerFertilizer(ItemStack itemStack, int value) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return;
        }
        this.fertilizers.put(itemStack, value);
    }

    @Override
    public int getFertilizeValue(ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> fertilizer : this.fertilizers.entrySet()) {
            ItemStack fertilizerStack = fertilizer.getKey();
            if (itemStack.func_77973_b() != fertilizerStack.func_77973_b() || fertilizerStack.func_77952_i() != itemStack.func_77952_i() && fertilizerStack.func_77952_i() != Short.MAX_VALUE) continue;
            return fertilizer.getValue();
        }
        return 0;
    }

    public void loadConfig(LocalizedConfiguration config) {
        ArrayList<String> defaultFertilizers = new ArrayList<String>(this.getItemStrings());
        Collections.sort(defaultFertilizers);
        String[] defaultSortedFertilizers = defaultFertilizers.toArray(new String[defaultFertilizers.size()]);
        Property fertilizerConf = config.get("fertilizers", "items", defaultSortedFertilizers, Translator.translateToLocal("for.config.farm.fertilizers.items"));
        this.fertilizers.clear();
        String[] fertilizerList = fertilizerConf.getStringList();
        for (int i = 0; i < fertilizerList.length; ++i) {
            try {
                String fertilizer = fertilizerList[i];
                String[] fertilizers = fertilizer.split(";");
                String itemName = fertilizers[0];
                if (itemName.equals("forestry:fertilizerCompound")) {
                    itemName = "forestry:fertilizer_compound";
                }
                ItemStack fertilizerItem = ItemStackUtil.parseItemStackString(itemName, Short.MAX_VALUE);
                int fertilizerValue = Integer.parseInt(fertilizers[1]);
                this.registerFertilizer(fertilizerItem, fertilizerValue);
                continue;
            }
            catch (Exception e) {
                Log.error("Forestry failed to parse a fertilizer entry at the farm config, at the position " + i + ".", e);
            }
        }
    }

    private Set<String> getItemStrings() {
        HashSet<String> itemStrings = new HashSet<String>(this.fertilizers.size());
        for (Map.Entry<ItemStack, Integer> itemStack : this.fertilizers.entrySet()) {
            String itemString = ItemStackUtil.getStringForItemStack(itemStack.getKey());
            itemString = itemString + ";" + itemStack.getValue();
            itemStrings.add(itemString);
        }
        return itemStrings;
    }

    static {
        ForestryAPI.farmRegistry = INSTANCE;
    }
}

