/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.collect.ImmutableList;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.api.genetics.IFruitBearer;
import forestry.core.PluginCore;
import forestry.core.tiles.TileUtil;
import forestry.farming.FarmRegistry;
import forestry.farming.logic.CropFruit;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmLogicOrchard
extends FarmLogic {
    private final Collection<IFarmable> farmables;
    private final HashMap<BlockPos, Integer> lastExtents = new HashMap();
    private final ImmutableList<Block> traversalBlocks;

    public FarmLogicOrchard() {
        this.farmables = FarmRegistry.getInstance().getFarmables("farmOrchard");
        ImmutableList.Builder traversalBlocksBuilder = ImmutableList.builder();
        traversalBlocksBuilder.build();
        this.traversalBlocks = traversalBlocksBuilder.build();
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(40.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        return NonNullList.func_191196_a();
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        int lastExtent;
        if (!this.lastExtents.containsKey(pos)) {
            this.lastExtents.put(pos, 0);
        }
        if ((lastExtent = this.lastExtents.get(pos).intValue()) > extent) {
            lastExtent = 0;
        }
        BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(world, position);
        this.lastExtents.put(pos, ++lastExtent);
        return crops;
    }

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack((Item)PluginCore.getItems().fruits);
    }

    @Override
    public String getName() {
        return "Orchard";
    }

    @Override
    public void addSoil(ItemStack resource, IBlockState soilState, boolean hasMetaData) {
    }

    private Collection<ICrop> getHarvestBlocks(World world, BlockPos position) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        Stack<ICrop> crops = new Stack<ICrop>();
        IBlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        if (!(block.isWood((IBlockAccess)world, position) || FarmLogicOrchard.isBlockTraversable(blockState, this.traversalBlocks) || this.isFruitBearer(world, position))) {
            return crops;
        }
        List<BlockPos> candidates = this.processHarvestBlock(world, crops, seen, position, position);
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (BlockPos candidate : candidates) {
                temp.addAll(this.processHarvestBlock(world, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<BlockPos> processHarvestBlock(World world, Stack<ICrop> crops, Set<BlockPos> seen, BlockPos start, BlockPos position) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int i = -2; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos candidate = position.func_177982_a(i, j, k);
                    if (Math.abs(candidate.func_177958_n() - start.func_177958_n()) > 5 || Math.abs(candidate.func_177952_p() - start.func_177952_p()) > 5 || seen.contains(candidate) || world.func_175623_d(candidate)) continue;
                    IBlockState blockState = world.func_180495_p(candidate);
                    Block block = blockState.func_177230_c();
                    if (block.isWood((IBlockAccess)world, candidate) || FarmLogicOrchard.isBlockTraversable(blockState, this.traversalBlocks)) {
                        candidates.add(candidate);
                        seen.add(candidate);
                    }
                    if (!this.isFruitBearer(world, candidate)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                    ICrop crop = this.getCrop(world, candidate);
                    if (crop == null) continue;
                    crops.push(crop);
                }
            }
        }
        return candidates;
    }

    private boolean isFruitBearer(World world, BlockPos position) {
        IFruitBearer tile = TileUtil.getTile((IBlockAccess)world, position, IFruitBearer.class);
        if (tile != null) {
            return true;
        }
        for (IFarmable farmable : this.farmables) {
            if (!farmable.isSaplingAt(world, position)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBlockTraversable(IBlockState blockState, ImmutableList<Block> traversalBlocks) {
        Block candidate = blockState.func_177230_c();
        for (Block block : traversalBlocks) {
            if (block != candidate) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private ICrop getCrop(World world, BlockPos position) {
        IFruitBearer fruitBearer = TileUtil.getTile((IBlockAccess)world, position, IFruitBearer.class);
        if (fruitBearer != null) {
            if (fruitBearer.hasFruit() && fruitBearer.getRipeness() >= 0.9f) {
                return new CropFruit(world, position);
            }
        } else {
            IBlockState blockState = world.func_180495_p(position);
            for (IFarmable seed : this.farmables) {
                ICrop crop = seed.getCropAt(world, position, blockState);
                if (crop == null) continue;
                return crop;
            }
        }
        return null;
    }
}

