/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import com.google.common.base.Preconditions;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.network.PacketIdServer;
import forestry.core.utils.Log;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketHandler {
    public static final String channelId = "FOR";
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("FOR");

    public PacketHandler() {
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBufferForestry data = new PacketBufferForestry(event.getPacket().payload());
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        byte packetIdOrdinal = data.readByte();
        PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
        IForestryPacketHandlerServer packetHandler = packetId.getPacketHandler();
        PacketHandler.checkThreadAndEnqueue(packetHandler, data, player, (IThreadListener)player.func_71121_q());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        PacketBufferForestry data = new PacketBufferForestry(event.getPacket().payload());
        byte packetIdOrdinal = data.readByte();
        PacketIdClient packetId = PacketIdClient.VALUES[packetIdOrdinal];
        IForestryPacketHandlerClient packetHandler = packetId.getPacketHandler();
        PacketHandler.checkThreadAndEnqueue(packetHandler, data, (IThreadListener)Minecraft.func_71410_x());
    }

    public void sendPacket(FMLProxyPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(packet, player);
    }

    @SideOnly(value=Side.CLIENT)
    private static void checkThreadAndEnqueue(IForestryPacketHandlerClient packet, PacketBufferForestry data, IThreadListener threadListener) {
        if (!threadListener.func_152345_ab()) {
            threadListener.func_152344_a(() -> {
                try {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    Preconditions.checkNotNull((Object)player, (Object)"Tried to send data to client before the player exists.");
                    packet.onPacketData(data, (EntityPlayer)player);
                }
                catch (IOException e) {
                    Log.error("Network Error", e);
                }
            });
        }
    }

    private static void checkThreadAndEnqueue(IForestryPacketHandlerServer packet, PacketBufferForestry data, EntityPlayerMP player, IThreadListener threadListener) {
        if (!threadListener.func_152345_ab()) {
            threadListener.func_152344_a(() -> {
                try {
                    packet.onPacketData(data, player);
                }
                catch (IOException e) {
                    Log.error("Network Error", e);
                }
            });
        }
    }
}

