/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.inventory;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.utils.InventoryUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryPlain implements IInventory, INbtWritable, INbtReadable {

	private final NonNullList<ItemStack> contents;
	private final String name;
	private final int stackLimit;

	public InventoryPlain(int size, String name, int stackLimit) {
		this.contents = NonNullList.func_191197_a(size, ItemStack.field_190927_a);
		this.name = name;
		this.stackLimit = stackLimit;
	}

	@Override
	public boolean func_191420_l() {
		for (ItemStack stack : contents) {
			if (!stack.func_190926_b()) {
				return false;
			}
		}
		return true;
	}

	public NonNullList<ItemStack> getContents() {
		return contents;
	}

	@Override
	public int func_70302_i_() {
		return contents.size();
	}

	@Override
	public ItemStack func_70301_a(int slotId) {
		return contents.get(slotId);
	}

	@Override
	public ItemStack func_70298_a(int slotId, int count) {
		ItemStack itemStack = contents.get(slotId);
		if (itemStack.func_190926_b()) {
			return ItemStack.field_190927_a;
		}
		return itemStack.func_77979_a(count);
	}

	@Override
	public void func_70299_a(int slotId, ItemStack itemstack) {
		contents.set(slotId, itemstack);
	}

	@Override
	public String func_70005_c_() {
		return name;
	}

	@Override
	public int func_70297_j_() {
		return stackLimit;
	}

	@Override
	public void func_70296_d() {
	}

	@Override
	public boolean func_70300_a(EntityPlayer entityplayer) {
		return false;
	}

	@Override
	public ItemStack func_70304_b(int slotIndex) {
		return this.func_70301_a(slotIndex);
	}

	@Override
	public boolean func_145818_k_() {
		return true;
	}

	@Override
	public ITextComponent func_145748_c_() {
		return new TextComponentString(func_70005_c_());
	}

	@Override
	public boolean func_94041_b(int i, ItemStack itemstack) {
		return true;
	}

	@Override
	public void func_174889_b(EntityPlayer player) {
	}

	@Override
	public void func_174886_c(EntityPlayer player) {
	}

	/* INBTagable */
	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {
		InventoryUtil.readFromNBT(this, nbttagcompound);
	}

	@Override
	public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
		InventoryUtil.writeToNBT(this, nbttagcompound);
		return nbttagcompound;
	}

	/* Fields */

	@Override
	public int func_174887_a_(int id) {
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value) {
	}

	@Override
	public int func_174890_g() {
		return 0;
	}

	@Override
	public void func_174888_l() {
	}
}
