/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import com.google.common.collect.Iterables;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.core.PluginCore;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.farming.FarmRegistry;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.farming.logic.FarmableSapling;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ForestryPlugin(pluginID="forestry.natura", name="Natura", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.natura.description")
public class PluginNatura
extends BlankForestryPlugin {
    public static final String modId = "natura";
    private static ArrayList<ItemStack> fruits = new ArrayList();
    private static ArrayList<ItemStack> soups = new ArrayList();
    private static ArrayList<ItemStack> berries = new ArrayList();
    private static ArrayList<ItemStack> edibles = new ArrayList();
    private static ArrayList<ItemStack> seeds = new ArrayList();
    private static ArrayList<ItemStack> logs = new ArrayList();
    private static ArrayList<ItemStack> saplings = new ArrayList();
    private static ArrayList<ItemStack> shrooms = new ArrayList();
    private static ArrayList<ItemStack> materials = new ArrayList();
    private static ArrayList<ItemStack> crops = new ArrayList();
    private static ArrayList<ItemStack> cropBlocks = new ArrayList();

    public PluginNatura() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(modId);
    }

    @Override
    public String getFailMessage() {
        return "Natura not found";
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent<Item> itemRegistryEvent) {
        ForgeRegistries.ITEMS.forEach(item -> {
            ResourceLocation registryName = item.getRegistryName();
            if (!registryName.func_110624_b().equals(modId)) {
                return;
            }
            String itemName = registryName.func_110623_a();
            if (itemName.matches("^.*_sapling\\d?$")) {
                this.consumeSubItems((Item)item, "saplings", (Collection<ItemStack>)saplings);
                RecipeUtil.addFermenterRecipes(new ItemStack(item, 1, Short.MAX_VALUE), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
                FarmRegistry.getInstance().registerFarmables("farmArboreal", new FarmableSapling(new ItemStack(item), new ItemStack[0]));
                return;
            }
            if (itemName.matches("^edibles|.*fruit_item|soups$")) {
                this.complexConsumeSubItems((Item)item, "edibles", subitem -> {
                    String subItemName = subitem.func_77977_a();
                    if (subItemName.matches("^.*berry$")) {
                        berries.add((ItemStack)subitem);
                        return;
                    }
                    if (subItemName.matches("^.*(fruit_item|apple)$")) {
                        fruits.add((ItemStack)subitem);
                        return;
                    }
                    if (subItemName.matches("^.*stew$")) {
                        soups.add((ItemStack)subitem);
                        return;
                    }
                    edibles.add((ItemStack)subitem);
                });
            }
            if (itemName.matches("^.*_seeds$")) {
                this.consumeSubItems((Item)item, "seeds", (Collection<ItemStack>)seeds);
                return;
            }
            if (itemName.matches("^.*_logs\\d?$")) {
                this.consumeSubItems((Item)item, "logs", (Collection<ItemStack>)logs);
                return;
            }
            if (itemName.matches("^.*_crop\\d?$")) {
                this.consumeSubItems((Item)item, "cropBlocks", (Collection<ItemStack>)cropBlocks);
                return;
            }
            if (itemName.matches("^materials$")) {
                this.complexConsumeSubItems((Item)item, "materials", subitem -> {
                    String subItemName = subitem.func_77977_a();
                    if (subItemName.matches("^.*(barley|cotton)$")) {
                        crops.add((ItemStack)subitem);
                        return;
                    }
                    materials.add((ItemStack)subitem);
                });
            }
        });
    }

    private void consumeSubItems(Item item, String groupName, Collection<ItemStack> consumer) {
        this.complexConsumeSubItems(item, groupName, subItem -> consumer.add((ItemStack)subItem));
    }

    private void complexConsumeSubItems(Item item, String groupName, Consumer<ItemStack> consumer) {
        NonNullList subItems = NonNullList.func_191196_a();
        item.func_150895_a(CreativeTabs.field_78027_g, subItems);
        if (subItems.isEmpty()) {
            ItemStack itemStack2 = new ItemStack(item, 1);
            String subItemName = itemStack2.func_77977_a();
            Log.info("[PluginNatura] Adding '{}' to list of {}", subItemName, groupName);
            consumer.accept(itemStack2);
            return;
        }
        subItems.forEach(itemStack -> {
            String subItemName = itemStack.func_77977_a();
            Log.info("[PluginNatura] Adding '{}' to list of {}", subItemName, groupName);
            consumer.accept((ItemStack)itemStack);
        });
    }

    @Override
    public void registerCrates() {
        super.registerCrates();
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        Iterables.concat((Iterable[])new Iterable[]{edibles, logs, saplings, shrooms, materials, seeds, berries, fruits, crops}).forEach(item -> crateRegistry.registerCrate((ItemStack)item));
    }

    @Override
    public void registerRecipes() {
        int amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        for (ItemStack seed : seeds) {
            RecipeManagers.squeezerManager.addRecipe(10, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)seed, (Object[])new ItemStack[]{seed}), Fluids.SEED_OIL.getFluid(amount));
            RecipeManagers.moistenerManager.addRecipe(seed, new ItemStack((Block)Blocks.field_150391_bh), 5000);
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.farming")) {
            cropBlocks.forEach(itemStack -> {
                ItemStack seedItem;
                int maxAge;
                Block block = ItemStackUtil.getBlock(itemStack);
                try {
                    maxAge = (Integer)block.getClass().getDeclaredMethod("getMaxAge", new Class[0]).invoke((Object)block, new Object[0]);
                    seedItem = block.getPickBlock(block.func_176194_O().func_177621_b(), null, null, null, null);
                }
                catch (Exception ignored) {
                    return;
                }
                Log.info("[PluginNatura] Addding crop '{}'", itemStack);
                if (seedItem.func_190926_b()) {
                    return;
                }
                FarmRegistry.getInstance().registerFarmables("farmWheat", new FarmableAgingCrop(seedItem, block, (IProperty<Integer>)block.func_176194_O().func_185920_a("age"), maxAge));
            });
        }
        amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 2;
        int juiceAmount = Math.max(amount, 1);
        ItemStack mulch = PluginCore.items.mulch.getItemStack();
        fruits.forEach(fruit -> RecipeManagers.squeezerManager.addRecipe(10, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)fruit, (Object[])new ItemStack[]{fruit}), Fluids.JUICE.getFluid(juiceAmount), mulch, ForestryAPI.activeMode.getIntegerSetting("squeezer.mulch.apple")));
        amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 25;
        amount = Math.max(amount, 1);
        for (ItemStack berry : berries) {
            RecipeManagers.squeezerManager.addRecipe(3, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)berry, (Object[])new ItemStack[]{berry}), Fluids.JUICE.getFluid(amount));
        }
        crops.forEach(crop -> {
            RecipeUtil.addFermenterRecipes(crop, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
            if (crop.func_77977_a().matches("^.*cotton$")) {
                return;
            }
            int compostWheatAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.wheat");
            if (compostWheatAmount > 0) {
                ItemStack compostWheat = PluginCore.items.fertilizerCompound.getItemStack(compostWheatAmount);
                RecipeUtil.addRecipe(compostWheat.func_77977_a(), compostWheat, " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), crop);
            }
            FuelManager.moistenerResource.put((ItemStack)crop, new MoistenerFuel((ItemStack)crop, PluginCore.items.mouldyWheat.getItemStack(), 0, 300));
        });
    }
}

