/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.entities;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ParticleSmoke extends Particle {
	private final float ignitionParticleScale;

	public ParticleSmoke(World world, double x, double y, double z) {
		super(world, x, y, z, 0, 0, 0);
		this.field_187129_i *= 0.8;
		this.field_187130_j *= 0.8;
		this.field_187131_k *= 0.8;
		this.field_187130_j = this.field_187136_p.nextFloat() * 0.2F + 0.05F;
		this.field_70552_h = this.field_70553_i = this.field_70551_j = 1.0F;
		this.field_70544_f *= this.field_187136_p.nextFloat() / 4;
		this.ignitionParticleScale = this.field_70544_f;
		this.field_70547_e = (int) (16.0 / (Math.random() * 0.8 + 0.2));
		this.func_70536_a(49);
	}

	@Override
	public int func_189214_a(float p_70070_1_) {
		int i = super.func_189214_a(p_70070_1_);
		int j = i >> 16 & 255;
		return 240 | j << 16;
	}

	@Override
	public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
		float f6 = (this.field_70546_d + partialTicks) / this.field_70547_e;
		this.field_70544_f = this.ignitionParticleScale * (1.0F - f6 * f6);
		super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
	}

	/**
	 * Called to update the entity's position/logic.
	 */
	@Override
	public void func_189213_a() {
		this.field_187123_c = this.field_187126_f;
		this.field_187124_d = this.field_187127_g;
		this.field_187125_e = this.field_187128_h;

		if (this.field_70546_d++ >= this.field_70547_e) {
			this.func_187112_i();
		}

		float f = (float) this.field_70546_d / (float) this.field_70547_e;

		if (this.field_187136_p.nextFloat() > f * 2) {
			this.field_187122_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i, this.field_187130_j, this.field_187131_k);
		}

		this.field_187130_j -= 0.03D;
		this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
		this.field_187129_i *= 0.999D;
		this.field_187130_j *= 0.999D;
		this.field_187131_k *= 0.999D;

		if (this.field_187132_l) {
			this.field_187129_i *= 0.7;
			this.field_187131_k *= 0.7;
		}
	}
}
