/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.core.PluginCore;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ForestryPlugin(pluginID="forestry.biomes.o.plenty", name="BiomesOPlenty", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.biomesoplenty.description")
public class PluginBiomesOPlenty
extends BlankForestryPlugin {
    private static final String BoP = "BiomesOPlenty";
    @Nullable
    private static Block saplings;
    @Nullable
    private static Block colorizedSaplings;
    @Nullable
    private static Item food;
    private static int amount;

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(BoP);
    }

    @Override
    public String getFailMessage() {
        return "BiomesOPlenty not found";
    }

    @Override
    public void doInit() {
        super.doInit();
        saplings = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(BoP, "saplings"));
        colorizedSaplings = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(BoP, "colorizedSaplings"));
        food = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(BoP, "food"));
        if (ForestryAPI.enabledPlugins.contains("forestry.apiculture")) {
            PluginBiomesOPlenty.addFlowers();
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.farming")) {
            PluginBiomesOPlenty.addFarmCrops();
        }
    }

    @Override
    public void registerRecipes() {
        super.registerRecipes();
        amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        if (ForestryAPI.enabledPlugins.contains("forestry.factory")) {
            PluginBiomesOPlenty.addFermenterRecipes();
            PluginBiomesOPlenty.addSqueezerRecipes();
        }
    }

    private static void addFarmCrops() {
        Item boPTurnipSeeds;
        ItemStack boPTurnipSeedStack;
        ArrayList<String> saplingItemKeys = new ArrayList<String>();
        if (saplings != null) {
            saplingItemKeys.add("saplings");
        }
        if (colorizedSaplings != null) {
            saplingItemKeys.add("colorizedSaplings");
        }
        for (String key : saplingItemKeys) {
            Item saplingItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(BoP, key));
            String saplingName = ItemStackUtil.getItemNameFromRegistryAsString(saplingItem);
            if (saplingName == null) continue;
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.-1", saplingName));
        }
        Block boPTurnip = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(BoP, "turnip"));
        if (ForestryAPI.enabledPlugins.contains("forestry.farming") && boPTurnip != null && !(boPTurnipSeedStack = new ItemStack(boPTurnipSeeds = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(BoP, "turnipSeeds")), 1, 0)).func_190926_b() && ForestryAPI.enabledPlugins.contains("forestry.factory")) {
            RecipeManagers.squeezerManager.addRecipe(10, boPTurnipSeedStack, Fluids.SEED_OIL.getFluid(amount));
        }
    }

    private static void addFermenterRecipes() {
        int saplingYield = ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling");
        if (saplings != null && saplings != Blocks.field_150350_a) {
            RecipeUtil.addFermenterRecipes(new ItemStack(saplings, 1, Short.MAX_VALUE), saplingYield, Fluids.BIOMASS);
        }
        if (colorizedSaplings != null && colorizedSaplings != Blocks.field_150350_a) {
            RecipeUtil.addFermenterRecipes(new ItemStack(colorizedSaplings, 1, Short.MAX_VALUE), saplingYield, Fluids.BIOMASS);
        }
    }

    private static void addSqueezerRecipes() {
        Item persimmon;
        ItemStack mulch = new ItemStack((Item)PluginCore.getItems().mulch);
        Item pinecone = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(BoP, "pinecone"));
        if (pinecone != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(pinecone), Fluids.SEED_OIL.getFluid(3 * amount));
        }
        if (food != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(food), Fluids.JUICE.getFluid(50), mulch, 5);
        }
        if ((persimmon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(BoP, "persimmon"))) != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(persimmon), Fluids.JUICE.getFluid(200), mulch, 20);
        }
    }

    private static void addFlowers() {
    }

    @Override
    public void registerBackpackItems() {
        PluginBiomesOPlenty.addBlocksToBackpack("forestry.miner", "driedDirt", "overgrownNetherrack", "cragRock", "ashStone");
        PluginBiomesOPlenty.addBlocksToBackpack("forestry.digger", "bopGrass", "newBopGrass", "longGrass", "mud", "hardDirt", "hardSand", "originGrass", "ash", "newBopDirt");
        PluginBiomesOPlenty.addBlocksToBackpack("forestry.forester", "petals");
    }

    private static void addBlocksToBackpack(String backpackUid, String ... blockNames) {
        for (String blockName : blockNames) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(BoP, blockName));
            if (block != null) {
                Item item = Item.func_150898_a((Block)block);
                ItemStack blockStack = new ItemStack(item, 1, Short.MAX_VALUE);
                if (!blockStack.func_190926_b()) {
                    BackpackManager.backpackInterface.addItemToForestryBackpack(backpackUid, blockStack);
                    continue;
                }
                Log.warning("Could not find an item for block: {}", blockName);
                continue;
            }
            Log.warning("Missing block: {}", blockName);
        }
    }
}

