/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.genetics.IIndividual;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.CropDestroy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmableSapling
implements IFarmable {
    protected final ItemStack germling;
    protected final boolean ignoreMetadata;
    protected final Block saplingBlock;
    protected final ItemStack[] windfall;

    public FarmableSapling(ItemStack germling, ItemStack[] windfall) {
        this(germling, windfall, true);
    }

    public FarmableSapling(ItemStack germling, ItemStack[] windfall, boolean addSubItems) {
        this.germling = germling;
        this.windfall = windfall;
        this.saplingBlock = ItemStackUtil.getBlock(germling);
        this.ignoreMetadata = addSubItems;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        IIndividual tree;
        if (ForestryAPI.enabledPlugins.contains("forestry.arboriculture") && (tree = GeneticsUtil.getGeneticEquivalent(germling)) instanceof ITree) {
            return TreeManager.treeRoot.plantSapling(world, (ITree)tree, player.func_146103_bH(), pos);
        }
        ItemStack copy = germling.func_77946_l();
        player.func_184611_a(EnumHand.MAIN_HAND, copy);
        EnumActionResult actionResult = copy.func_179546_a(player, world, pos.func_177977_b(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
        player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        if (actionResult == EnumActionResult.SUCCESS) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, Blocks.field_150345_g.func_176223_P());
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this.saplingBlock;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (!block.isWood((IBlockAccess)world, pos)) {
            return null;
        }
        return new CropDestroy(world, blockState, pos, null);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        if (this.ignoreMetadata) {
            return ItemStack.func_179545_c((ItemStack)this.germling, (ItemStack)new ItemStack(itemstack.func_77973_b()));
        }
        return ItemStack.func_179545_c((ItemStack)this.germling, (ItemStack)itemstack);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }
}

