/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import forestry.api.recipes.IDescriptiveRecipe;
import forestry.core.utils.ItemStackUtil;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedRecipeCustom
extends ShapedOreRecipe
implements IDescriptiveRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private NonNullList<NonNullList<ItemStack>> input;
    private NonNullList<String> oreDicts;
    private int width;
    private int height;
    private boolean mirrored = true;

    public ShapedRecipeCustom(ItemStack result, Object ... recipe) {
        super(null, result, recipe);
        ItemStack output = result.func_77946_l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, NonNullList> itemMap = new HashMap<Character, NonNullList>();
        HashMap<Character, String> oreMap = new HashMap<Character, String>();
        while (idx < recipe.length) {
            ItemStack itemStack;
            NonNullList ingredient;
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                ItemStack copy = ((ItemStack)in).func_77946_l();
                ingredient = NonNullList.func_191196_a();
                ingredient.add((Object)copy);
                itemMap.put(chr, ingredient);
            } else if (in instanceof Item) {
                itemStack = new ItemStack((Item)in);
                ingredient = NonNullList.func_191196_a();
                ingredient.add((Object)itemStack);
                itemMap.put(chr, ingredient);
            } else if (in instanceof Block) {
                itemStack = new ItemStack((Block)in, 1, Short.MAX_VALUE);
                ingredient = NonNullList.func_191196_a();
                ingredient.add((Object)itemStack);
                itemMap.put(chr, ingredient);
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
                oreMap.put(chr, (String)in);
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = NonNullList.func_191197_a((int)shape.length(), (Object)NonNullList.func_191196_a());
        this.oreDicts = NonNullList.func_191197_a((int)shape.length(), (Object)"");
        int x = 0;
        for (char chr : shape.toCharArray()) {
            NonNullList stacks = (NonNullList)itemMap.get(Character.valueOf(chr));
            if (stacks != null) {
                this.input.set(x, (Object)stacks);
                if (oreMap.get(Character.valueOf(chr)) != null) {
                    this.oreDicts.set(x, oreMap.get(Character.valueOf(chr)));
                }
            }
            ++x;
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public NonNullList<NonNullList<ItemStack>> getRawIngredients() {
        return this.input;
    }

    @Override
    public NonNullList<String> getOreDicts() {
        return this.oreDicts;
    }

    @Override
    public ItemStack getOutput() {
        return this.func_77571_b();
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_192399_d() {
        return false;
    }

    public boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                NonNullList target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? (NonNullList)this.input.get(this.width - subX - 1 + subY * this.width) : (NonNullList)this.input.get(subX + subY * this.width);
                }
                ItemStack stackInSlot = inv.func_70463_b(x, y);
                if (target != null && !target.isEmpty()) {
                    boolean matched = false;
                    Iterator itr = target.iterator();
                    while (itr.hasNext() && !matched) {
                        matched = ItemStackUtil.isCraftingEquivalent((ItemStack)itr.next(), stackInSlot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (stackInSlot.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public static ShapedRecipeCustom createShapedRecipe(ItemStack product, Object ... materials) {
        return new ShapedRecipeCustom(product, materials);
    }
}

