/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology;

import java.util.Random;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.lepidopterology.entities.EntityButterfly;

public class ButterflySpawner implements ILeafTickHandler {

	@Override
	public boolean onRandomLeafTick(ITree tree, World world, Random rand, BlockPos pos, boolean isDestroyed) {

		if (rand.nextFloat() >= tree.getGenome().getSappiness() * tree.getGenome().getYield()) {
			return false;
		}

		IButterfly spawn = ButterflyManager.butterflyRoot.getIndividualTemplates().get(rand.nextInt(ButterflyManager.butterflyRoot.getIndividualTemplates().size()));
		float rarity;
		if (!PluginLepidopterology.spawnRaritys.containsKey(spawn.getGenome().getPrimary().getUID())) {
			rarity = spawn.getGenome().getPrimary().getRarity();
		} else {
			rarity = PluginLepidopterology.spawnRaritys.get(spawn.getGenome().getPrimary().getUID());
		}

		if (rand.nextFloat() >= rarity * 0.5f) {
			return false;
		}

		if (world.func_72907_a(EntityButterfly.class) > PluginLepidopterology.spawnConstraint) {
			return false;
		}

		if (!spawn.canSpawn(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
			return false;
		}

		if (world.func_175623_d(pos.func_177978_c())) {
			ButterflyUtils.attemptButterflySpawn(world, spawn, pos.func_177978_c());
		} else if (world.func_175623_d(pos.func_177968_d())) {
			ButterflyUtils.attemptButterflySpawn(world, spawn, pos.func_177968_d());
		} else if (world.func_175623_d(pos.func_177976_e())) {
			ButterflyUtils.attemptButterflySpawn(world, spawn, pos.func_177976_e());
		} else if (world.func_175623_d(pos.func_177974_f())) {
			ButterflyUtils.attemptButterflySpawn(world, spawn, pos.func_177974_f());
		}

		return false;
	}

}
