/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.IBackpackFilterConfigurable;
import forestry.api.storage.IBackpackInterface;
import forestry.core.utils.ItemStackUtil;
import forestry.storage.BackpackFilter;
import forestry.storage.BackpackFilterNaturalist;
import forestry.storage.items.ItemBackpack;
import forestry.storage.items.ItemBackpackNaturalist;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BackpackInterface
implements IBackpackInterface {
    private final Map<String, IBackpackDefinition> definitions = new HashMap<String, IBackpackDefinition>();
    private final Multimap<String, String> backpackAcceptedItems = HashMultimap.create();

    public Multimap<String, String> getBackpackAcceptedItems() {
        return this.backpackAcceptedItems;
    }

    @Override
    public void addItemToForestryBackpack(String backpackUid, ItemStack itemStack) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack must not be null");
        Preconditions.checkArgument((!itemStack.func_190926_b() ? 1 : 0) != 0, (Object)"itemStack must not be empty");
        String stringForItemStack = ItemStackUtil.getStringForItemStack(itemStack);
        this.backpackAcceptedItems.put((Object)backpackUid, (Object)stringForItemStack);
    }

    @Override
    public void registerBackpackDefinition(String backpackUid, IBackpackDefinition definition) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        Preconditions.checkNotNull((Object)definition, (Object)"definition must not be null");
        this.definitions.put(backpackUid, definition);
    }

    @Override
    @Nullable
    public IBackpackDefinition getBackpackDefinition(String backpackUid) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        return this.definitions.get(backpackUid);
    }

    @Override
    public Item createBackpack(String backpackUid, EnumBackpackType type) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type must not be null");
        Preconditions.checkArgument((type != EnumBackpackType.NATURALIST ? 1 : 0) != 0, (Object)"type must not be NATURALIST. Use createNaturalistBackpack instead.");
        IBackpackDefinition definition = this.definitions.get(backpackUid);
        if (definition == null) {
            throw new IllegalArgumentException("No backpack definition was registered for UID: " + backpackUid);
        }
        return new ItemBackpack(definition, type);
    }

    @Override
    public Item createNaturalistBackpack(String backpackUid, ISpeciesRoot speciesRoot) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        Preconditions.checkNotNull((Object)speciesRoot, (Object)"speciesRoot must not be null");
        IBackpackDefinition definition = this.definitions.get(backpackUid);
        if (definition == null) {
            throw new IllegalArgumentException("No backpack definition was registered for UID: " + backpackUid);
        }
        return new ItemBackpackNaturalist(speciesRoot, definition);
    }

    @Override
    public IBackpackFilterConfigurable createBackpackFilter() {
        return new BackpackFilter();
    }

    @Override
    public Predicate<ItemStack> createNaturalistBackpackFilter(String speciesRootUid) {
        return new BackpackFilterNaturalist(speciesRootUid);
    }
}

