/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import forestry.api.core.ICamouflageAccess;
import forestry.api.core.ICamouflageItemHandler;
import forestry.core.CamouflageHandlerNone;
import forestry.core.utils.Log;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class CamouflageAccess
implements ICamouflageAccess {
    private static final ListMultimap<String, ICamouflageItemHandler> camouflageItemHandlers = ArrayListMultimap.create();
    private static final ListMultimap<String, ItemStack> camouflageItemBlacklist = ArrayListMultimap.create();
    private static final ListMultimap<String, String> blacklistedMods = ArrayListMultimap.create();
    public static final ICamouflageItemHandler NONE = new CamouflageHandlerNone();

    @Override
    public void registerCamouflageItemHandler(ICamouflageItemHandler itemHandler) {
        String type = itemHandler.getType();
        List handlers = camouflageItemHandlers.get((Object)type);
        if (!handlers.contains(itemHandler)) {
            handlers.add(itemHandler);
        } else {
            Log.error("Fail to register a camouflage item handler, because the handler is already registered. The handler is form the mod with the ID: " + Loader.instance().activeModContainer().getModId() + ".", new Object[0]);
        }
    }

    @Override
    public List<ICamouflageItemHandler> getCamouflageItemHandler(String type) {
        if (type.equals("none")) {
            ArrayList<ICamouflageItemHandler> handlers = new ArrayList<ICamouflageItemHandler>();
            handlers.addAll(camouflageItemHandlers.values());
            return handlers;
        }
        return camouflageItemHandlers.get((Object)type);
    }

    @Override
    public void addModIdToBlackList(String type, String modID) {
        if (!blacklistedMods.get((Object)type).contains(modID)) {
            blacklistedMods.put((Object)type, (Object)modID);
        }
    }

    @Override
    public void addItemToBlackList(String type, ItemStack camouflageBlock) {
        Block block = Block.func_149634_a((Item)camouflageBlock.func_77973_b());
        if (block == Blocks.field_150350_a) {
            Log.error("Fail to add camouflage block item to the black list: because it has no block.", new Object[0]);
            return;
        }
        for (ItemStack camouflageBlacklisted : camouflageItemBlacklist.get((Object)type)) {
            if (camouflageBlacklisted.func_77973_b() != camouflageBlock.func_77973_b() || camouflageBlacklisted.func_77952_i() != camouflageBlock.func_77952_i() || !ItemStack.func_77970_a((ItemStack)camouflageBlock, (ItemStack)camouflageBlacklisted)) continue;
            Log.error("Fail to add camouflage block item to the black list, because it is already registered: " + camouflageBlock + ".", new Object[0]);
            return;
        }
        camouflageItemBlacklist.put((Object)type, (Object)camouflageBlock);
    }

    @Override
    public boolean isItemBlackListed(String type, ItemStack camouflageBlock) {
        List camouflageItemBlacklisted;
        if (camouflageBlock.func_190926_b() || Block.func_149634_a((Item)camouflageBlock.func_77973_b()) == Blocks.field_150350_a || !type.equals("none") && !camouflageItemBlacklist.containsKey((Object)type)) {
            return false;
        }
        String modId = camouflageBlock.func_77973_b().getRegistryName().func_110624_b();
        if (blacklistedMods.get((Object)type) != null && blacklistedMods.get((Object)type).contains(modId)) {
            return true;
        }
        if (type.equals("none")) {
            camouflageItemBlacklisted = new ArrayList();
            camouflageItemBlacklisted.addAll(camouflageItemBlacklist.values());
        } else {
            camouflageItemBlacklisted = camouflageItemBlacklist.get((Object)type);
        }
        for (ItemStack camouflageBlacklisted : camouflageItemBlacklisted) {
            if (camouflageBlacklisted.func_77973_b() != camouflageBlock.func_77973_b() || camouflageBlacklisted.func_77952_i() != camouflageBlock.func_77952_i() || !ItemStack.func_77970_a((ItemStack)camouflageBlock, (ItemStack)camouflageBlacklisted)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICamouflageItemHandler getNoneItemHandler() {
        return NONE;
    }

    @Override
    public ICamouflageItemHandler getHandlerFromItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return NONE;
        }
        for (ICamouflageItemHandler handler : camouflageItemHandlers.values()) {
            if (!handler.canHandle(stack)) continue;
            return handler;
        }
        return NONE;
    }
}

