/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.core.ForestryAPI;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicHomogeneous;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicEnder
extends FarmLogicHomogeneous {
    public FarmLogicEnder() {
        super(new ItemStack(Blocks.field_150377_bs), Blocks.field_150377_bs.func_176223_P(), ForestryAPI.farmRegistry.getFarmables("farmEnder"));
    }

    @Override
    public String getName() {
        return "Managed Ender Farm";
    }

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack(Items.field_151061_bv);
    }

    @Override
    public int getFertilizerConsumption() {
        return 20;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 0;
    }

    @Override
    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        return NonNullList.func_191196_a();
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        Stack<ICrop> crops = new Stack<ICrop>();
        block0: for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, i);
            IBlockState blockState = world.func_180495_p(position);
            for (IFarmable farmable : this.farmables) {
                ICrop crop = farmable.getCropAt(world, position, blockState);
                if (crop == null) continue;
                crops.push(crop);
                continue block0;
            }
        }
        return crops;
    }

    @Override
    protected boolean maintainGermlings(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPos;
            IBlockState blockState;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState state = world.func_180495_p(position);
            if (!world.func_175623_d(position) && !BlockUtil.isReplaceableBlock(state, world, position) || !this.isAcceptedSoil(blockState = world.func_180495_p(soilPos = position.func_177977_b()))) continue;
            return this.trySetCrop(world, farmHousing, position);
        }
        return false;
    }

    private boolean trySetCrop(World world, IFarmHousing farmHousing, BlockPos position) {
        for (IFarmable candidate : this.farmables) {
            if (!farmHousing.plantGermling(candidate, world, position)) continue;
            return true;
        }
        return false;
    }
}

