/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.base.Objects;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.Chromosome;
import forestry.core.utils.Log;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class Genome
implements IGenome {
    private static final String SLOT_TAG = "Slot";
    private final IChromosome[] chromosomes;

    protected Genome(NBTTagCompound nbttagcompound) {
        this.chromosomes = Genome.getChromosomes(nbttagcompound, this.getSpeciesRoot());
    }

    protected Genome(IChromosome[] chromosomes) {
        this.checkChromosomes(chromosomes);
        this.chromosomes = chromosomes;
    }

    private void checkChromosomes(IChromosome[] chromosomes) {
        if (chromosomes.length != this.getDefaultTemplate().length) {
            String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template.\n%s", this.getSpeciesRoot().getUID(), this.chromosomesToString(chromosomes));
            throw new IllegalArgumentException(message);
        }
        IChromosomeType[] karyotype = this.getSpeciesRoot().getKaryotype();
        for (int i = 0; i < karyotype.length; ++i) {
            IChromosomeType chromosomeType = karyotype[i];
            IChromosome chromosome = chromosomes[i];
            if (chromosome == null) {
                String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Missing chromosome '%s'.\n%s", this.getSpeciesRoot().getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
                throw new IllegalArgumentException(message);
            }
            IAllele primary = chromosome.getPrimaryAllele();
            if (primary == null) {
                String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Missing primary allele for '%s'.\n%s", this.getSpeciesRoot().getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
                throw new IllegalArgumentException(message);
            }
            IAllele secondary = chromosome.getSecondaryAllele();
            if (secondary == null) {
                String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Missing secondary allele for '%s'.\n%s", this.getSpeciesRoot().getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
                throw new IllegalArgumentException(message);
            }
            Class<? extends IAllele> chromosomeAlleleClass = chromosomeType.getAlleleClass();
            if (!chromosomeAlleleClass.isAssignableFrom(primary.getClass())) {
                String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Incorrect type for primary allele '%s'.\n%s.", this.getSpeciesRoot().getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
                throw new IllegalArgumentException(message);
            }
            if (chromosomeAlleleClass.isAssignableFrom(secondary.getClass())) continue;
            String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Incorrect type for secondary allele '%s'.\n%s.", this.getSpeciesRoot().getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
            throw new IllegalArgumentException(message);
        }
    }

    private String chromosomesToString(IChromosome[] chromosomes) {
        StringBuilder stringBuilder = new StringBuilder();
        IChromosomeType[] karyotype = this.getSpeciesRoot().getKaryotype();
        for (int i = 0; i < chromosomes.length; ++i) {
            IChromosomeType chromosomeType = karyotype[i];
            IChromosome chromosome = chromosomes[i];
            stringBuilder.append(chromosomeType.getName()).append(": ").append(chromosome).append("\n");
        }
        return stringBuilder.toString();
    }

    private IAllele[] getDefaultTemplate() {
        return this.getSpeciesRoot().getDefaultTemplate();
    }

    @Nullable
    public static IAlleleSpecies getSpeciesDirectly(ISpeciesRoot speciesRoot, ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null) {
            return null;
        }
        NBTTagCompound genomeNBT = nbtTagCompound.func_74775_l("Genome");
        if (genomeNBT.func_82582_d()) {
            return null;
        }
        NBTTagList chromosomesNBT = genomeNBT.func_150295_c("Chromosomes", 10);
        if (chromosomesNBT.func_82582_d()) {
            return null;
        }
        NBTTagCompound chromosomeNBT = chromosomesNBT.func_150305_b(0);
        Chromosome chromosome = Chromosome.create(null, null, speciesRoot.getSpeciesChromosomeType(), chromosomeNBT);
        IAllele activeAllele = chromosome.getActiveAllele();
        if (!(activeAllele instanceof IAlleleSpecies)) {
            return null;
        }
        return (IAlleleSpecies)activeAllele;
    }

    private static IChromosome getChromosome(ItemStack itemStack, IChromosomeType chromosomeType, ISpeciesRoot speciesRoot) {
        NBTTagCompound genomeNbt;
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            itemStack.func_77982_d(nbtTagCompound);
        }
        if ((genomeNbt = nbtTagCompound.func_74775_l("Genome")).func_82582_d()) {
            Log.error("Got a genetic item with no genome, setting it to a default value.", new Object[0]);
            genomeNbt = new NBTTagCompound();
            IAllele[] defaultTemplate = speciesRoot.getDefaultTemplate();
            IGenome genome = speciesRoot.templateAsGenome(defaultTemplate);
            genome.writeToNBT(genomeNbt);
            nbtTagCompound.func_74782_a("Genome", (NBTBase)genomeNbt);
        }
        IChromosome[] chromosomes = Genome.getChromosomes(genomeNbt, speciesRoot);
        return chromosomes[chromosomeType.ordinal()];
    }

    private static IChromosome[] getChromosomes(NBTTagCompound genomeNBT, ISpeciesRoot speciesRoot) {
        NBTTagList chromosomesNBT = genomeNBT.func_150295_c("Chromosomes", 10);
        IChromosome[] chromosomes = new IChromosome[speciesRoot.getDefaultTemplate().length];
        String primarySpeciesUid = null;
        String secondarySpeciesUid = null;
        for (int i = 0; i < chromosomesNBT.func_74745_c(); ++i) {
            NBTTagCompound chromosomeNBT = chromosomesNBT.func_150305_b(i);
            byte chromosomeOrdinal = chromosomeNBT.func_74771_c(SLOT_TAG);
            if (chromosomeOrdinal < 0 || chromosomeOrdinal >= chromosomes.length) continue;
            IChromosomeType chromosomeType = speciesRoot.getKaryotype()[chromosomeOrdinal];
            Chromosome chromosome = Chromosome.create(primarySpeciesUid, secondarySpeciesUid, chromosomeType, chromosomeNBT);
            chromosomes[chromosomeOrdinal] = chromosome;
            if (chromosomeOrdinal != speciesRoot.getSpeciesChromosomeType().ordinal()) continue;
            primarySpeciesUid = chromosome.getPrimaryAllele().getUID();
            secondarySpeciesUid = chromosome.getSecondaryAllele().getUID();
        }
        return chromosomes;
    }

    protected static IAllele getActiveAllele(ItemStack itemStack, IChromosomeType chromosomeType, ISpeciesRoot speciesRoot) {
        IChromosome chromosome = Genome.getChromosome(itemStack, chromosomeType, speciesRoot);
        return chromosome.getActiveAllele();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chromosomes.length; ++i) {
            if (this.chromosomes[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(SLOT_TAG, (byte)i);
            this.chromosomes[i].writeToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Chromosomes", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    @Override
    public IChromosome[] getChromosomes() {
        return Arrays.copyOf(this.chromosomes, this.chromosomes.length);
    }

    @Override
    public IAllele getActiveAllele(IChromosomeType chromosomeType) {
        return this.chromosomes[chromosomeType.ordinal()].getActiveAllele();
    }

    @Override
    public IAllele getInactiveAllele(IChromosomeType chromosomeType) {
        return this.chromosomes[chromosomeType.ordinal()].getInactiveAllele();
    }

    @Override
    public boolean isGeneticEqual(IGenome other) {
        IChromosome[] genetics = other.getChromosomes();
        if (this.chromosomes.length != genetics.length) {
            return false;
        }
        for (int i = 0; i < this.chromosomes.length; ++i) {
            IChromosome chromosome = this.chromosomes[i];
            IChromosome otherChromosome = genetics[i];
            if (chromosome == null && otherChromosome == null) continue;
            if (chromosome == null || otherChromosome == null) {
                return false;
            }
            if (!chromosome.getPrimaryAllele().getUID().equals(otherChromosome.getPrimaryAllele().getUID())) {
                return false;
            }
            if (chromosome.getSecondaryAllele().getUID().equals(otherChromosome.getSecondaryAllele().getUID())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this);
        int i = 0;
        for (IChromosome chromosome : this.chromosomes) {
            toStringHelper.add(String.valueOf(i++), (Object)chromosome);
        }
        return toStringHelper.toString();
    }
}

