/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.render.ParticleRender;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AlleleEffectIgnition
extends AlleleEffectThrottled {
    private static final int ignitionChance = 50;
    private static final int fireDuration = 500;

    public AlleleEffectIgnition() {
        super("ignition", false, 20, false, true);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        List<EntityLivingBase> entities = AlleleEffectIgnition.getEntitiesInRange(genome, housing, EntityLivingBase.class);
        for (EntityLivingBase entity : entities) {
            int chance = 50;
            int duration = 500;
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, this.getUID(), true);
            if (count > 3) continue;
            if (count > 2) {
                chance = 5;
                duration = 50;
            } else if (count > 1) {
                chance = 20;
                duration = 200;
            } else if (count > 0) {
                chance = 35;
                duration = 350;
            }
            if (world.field_73012_v.nextInt(1000) >= chance) continue;
            entity.func_70015_d(duration);
        }
        return storedData;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        if (world.field_73012_v.nextInt(2) != 0) {
            super.doFX(genome, storedData, housing);
        } else {
            Vec3d beeFXCoordinates = housing.getBeeFXCoordinates();
            ParticleRender.addEntityIgnitionFX(world, beeFXCoordinates.field_72450_a, beeFXCoordinates.field_72448_b + 0.5, beeFXCoordinates.field_72449_c);
        }
        return storedData;
    }
}

